/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.scripts.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class StaticAssetCacheFilter
implements Filter {
    private static final long DAY_S = 86400L;
    private static final long DEFAULT_30DAYS = 30L;
    private long expire = 2592000L;

    public void init(FilterConfig config) throws ServletException {
        String expireParam = config.getInitParameter("expires");
        if (expireParam != null) {
            this.expire = Long.parseLong(expireParam) * 86400L;
        }
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        ((HttpServletResponse)res).setHeader("Cache-Control", "public, must-revalidate, max-age=" + Long.toString(this.expire));
        chain.doFilter(req, res);
    }

    public void destroy() {
        this.expire = 2592000L;
    }
}

