/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.lang.jstl;

import org.apache.taglibs.standard.lang.jstl.BinaryOperator;
import org.apache.taglibs.standard.lang.jstl.Coercions;
import org.apache.taglibs.standard.lang.jstl.Constants;
import org.apache.taglibs.standard.lang.jstl.ELException;
import org.apache.taglibs.standard.lang.jstl.Logger;
import org.apache.taglibs.standard.lang.jstl.PrimitiveObjects;

public class DivideOperator
extends BinaryOperator {
    public static final DivideOperator SINGLETON = new DivideOperator();
    static /* synthetic */ Class class$java$lang$Double;

    public String getOperatorSymbol() {
        return "/";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public Object apply(Object pLeft, Object pRight, Object pContext, Logger pLogger) throws ELException {
        if (pLeft == null && pRight == null) {
            if (pLogger.isLoggingWarning()) {
                pLogger.logWarning(Constants.ARITH_OP_NULL, this.getOperatorSymbol());
            }
            return PrimitiveObjects.getInteger(0);
        }
        double left = Coercions.coerceToPrimitiveNumber(pLeft, class$java$lang$Double == null ? (class$java$lang$Double = DivideOperator.class$("java.lang.Double")) : class$java$lang$Double, pLogger).doubleValue();
        double right = Coercions.coerceToPrimitiveNumber(pRight, class$java$lang$Double == null ? (class$java$lang$Double = DivideOperator.class$("java.lang.Double")) : class$java$lang$Double, pLogger).doubleValue();
        try {
            return PrimitiveObjects.getDouble(left / right);
        }
        catch (Exception exc) {
            if (pLogger.isLoggingError()) {
                pLogger.logError(Constants.ARITH_ERROR, this.getOperatorSymbol(), (Object)("" + left), (Object)("" + right));
            }
            return PrimitiveObjects.getInteger(0);
        }
    }
}

