/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.webmastertools;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.Category;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.Kind;
import com.google.gdata.data.ValueConstruct;
import com.google.gdata.data.webmastertools.Namespaces;
import com.google.gdata.data.webmastertools.SitemapsEntry;

@Kind.Term(value="http://schemas.google.com/webmasters/tools/2007#sitemap-mobile")
public class SitemapsMobileEntry
extends SitemapsEntry<SitemapsMobileEntry> {
    private static final String MOBILE_MARKUP_LANG = "sitemap-mobile-markup-language";
    private static final Category CATEGORY = Namespaces.createCategory("http://schemas.google.com/webmasters/tools/2007#sitemap-mobile");

    public SitemapsMobileEntry() {
        this.getCategories().add(CATEGORY);
    }

    public SitemapsMobileEntry(BaseEntry<?> sourceEntry) {
        super(sourceEntry);
        this.getCategories().add(CATEGORY);
    }

    @Override
    public void declareExtensions(ExtensionProfile extProfile) {
        super.declareExtensions(extProfile);
        extProfile.declare(SitemapsMobileEntry.class, ExtensionDescription.getDefaultDescription(MarkupLanguage.class));
    }

    public void setMarkupLanguage(String value) {
        MarkupLanguage lang = (MarkupLanguage)this.getExtension(MarkupLanguage.class);
        if (lang == null) {
            lang = new MarkupLanguage();
            this.setExtension((Extension)lang);
        }
        lang.setValue(value);
    }

    public String getMarkupLanguage() {
        MarkupLanguage lang = (MarkupLanguage)this.getExtension(MarkupLanguage.class);
        if (lang == null) {
            return null;
        }
        return lang.getValue();
    }

    protected void validate() throws IllegalStateException {
        super.validate();
        if (this.getMarkupLanguage() == null) {
            throw new IllegalStateException("sitemap-mobile-markup-language is not set");
        }
    }

    @ExtensionDescription.Default(nsAlias="wt", nsUri="http://schemas.google.com/webmasters/tools/2007", localName="sitemap-mobile-markup-language")
    public static class MarkupLanguage
    extends ValueConstruct {
        public MarkupLanguage() {
            super(Namespaces.WT_NAMESPACE, SitemapsMobileEntry.MOBILE_MARKUP_LANG, null);
        }
    }
}

