/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.webmastertools;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.Category;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.Kind;
import com.google.gdata.data.ValueConstruct;
import com.google.gdata.data.webmastertools.Namespaces;
import com.google.gdata.data.webmastertools.SitemapsEntry;

@Kind.Term(value="http://schemas.google.com/webmasters/tools/2007#sitemap-news")
public class SitemapsNewsEntry
extends SitemapsEntry<SitemapsNewsEntry> {
    private static final String NEWS_PUBLICATION_LABEL = "sitemap-news-publication-label";
    private static final Category CATEGORY = Namespaces.createCategory("http://schemas.google.com/webmasters/tools/2007#sitemap-news");

    public SitemapsNewsEntry() {
        this.getCategories().add(CATEGORY);
    }

    public SitemapsNewsEntry(BaseEntry<?> sourceEntry) {
        super(sourceEntry);
        this.getCategories().add(CATEGORY);
    }

    @Override
    public void declareExtensions(ExtensionProfile extProfile) {
        super.declareExtensions(extProfile);
        extProfile.declare(SitemapsNewsEntry.class, ExtensionDescription.getDefaultDescription(PublicationLabel.class));
    }

    public void setPublicationLabel(String value) {
        PublicationLabel label = (PublicationLabel)this.getExtension(PublicationLabel.class);
        if (label == null) {
            label = new PublicationLabel();
            this.setExtension((Extension)label);
        }
        label.setValue(value);
    }

    public String getPublicationLabel() {
        PublicationLabel label = (PublicationLabel)this.getExtension(PublicationLabel.class);
        if (label == null) {
            return null;
        }
        return label.getValue();
    }

    protected void validate() throws IllegalStateException {
        super.validate();
        if (this.getPublicationLabel() == null) {
            throw new IllegalStateException("sitemap-news-publication-label is not set");
        }
    }

    @ExtensionDescription.Default(nsAlias="wt", nsUri="http://schemas.google.com/webmasters/tools/2007", localName="sitemap-news-publication-label")
    public static class PublicationLabel
    extends ValueConstruct {
        public PublicationLabel() {
            super(Namespaces.WT_NAMESPACE, SitemapsNewsEntry.NEWS_PUBLICATION_LABEL, null);
        }
    }
}

