/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.webmastertools;

import com.google.gdata.data.AbstractExtension;
import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.webmastertools.Namespaces;
import com.google.gdata.util.ParseException;

@ExtensionDescription.Default(nsAlias="wt", nsUri="http://schemas.google.com/webmasters/tools/2007", localName="verification-method")
public class VerificationMethod
extends AbstractExtension {
    private MethodType methodType = MethodType.METATAG;
    private boolean inUse = false;
    private String fileContent = "";
    private String value = "";
    public static final String METHOD_NODE = "verification-method";
    private static final String METHODTYPE = "type";
    private static final String INUSE = "in-use";
    private static final String FILECONTENT = "file-content";

    public static boolean matchesNode(String nodeName) {
        return nodeName.equals(METHOD_NODE);
    }

    public VerificationMethod() {
        super(Namespaces.WT_NAMESPACE, METHOD_NODE);
    }

    public boolean equals(Object rhs) {
        if (!this.sameClassAs(rhs)) {
            return false;
        }
        VerificationMethod r = (VerificationMethod)((Object)rhs);
        if (!this.methodType.equals((Object)r.methodType)) {
            return false;
        }
        if (this.inUse != r.inUse) {
            return false;
        }
        if (!this.fileContent.equals(r.fileContent)) {
            return false;
        }
        return this.value.equals(r.value);
    }

    public int hashCode() {
        return this.methodType.hashCode();
    }

    public void setMethodType(MethodType method) {
        this.methodType = method;
    }

    public MethodType getMethodType() {
        return this.methodType;
    }

    public void setInUse(boolean inUse) {
        this.inUse = inUse;
    }

    public boolean getInUse() {
        return this.inUse;
    }

    public void setFileContent(String fileContent) {
        this.fileContent = fileContent;
    }

    public String getFileContent() {
        return this.fileContent;
    }

    public void setValue(String v) {
        this.value = v;
    }

    public String getValue() {
        return this.value;
    }

    protected void putAttributes(AttributeGenerator generator) {
        generator.put((Object)METHODTYPE, (Object)this.methodType.toString().toLowerCase());
        generator.put(INUSE, this.inUse);
        generator.put((Object)FILECONTENT, (Object)this.fileContent);
        generator.setContent(this.value);
    }

    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        this.methodType = (MethodType)helper.consumeEnum(METHODTYPE, true, MethodType.class, (Enum)MethodType.METATAG);
        this.inUse = helper.consumeBoolean(INUSE, true);
        this.fileContent = helper.consume(FILECONTENT, false);
        String content = helper.consumeContent(false);
        if (content != null) {
            this.value = content;
        }
    }

    public static enum MethodType {
        METATAG,
        HTMLPAGE;

    }
}

