/*
 * Decompiled with CFR 0.152.
 */
package com.benfante.jslideshare;

import com.benfante.jslideshare.DocumentParserResult;
import com.benfante.jslideshare.SlideShareException;
import com.benfante.jslideshare.messages.Group;
import com.benfante.jslideshare.messages.Slideshow;
import com.benfante.jslideshare.messages.SlideshowInfo;
import com.benfante.jslideshare.messages.Tag;
import com.benfante.jslideshare.messages.User;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DocumentParser
extends DefaultHandler {
    public static final String COUNT_TAG = "count";
    public static final String DESCRIPTION_TAG = "Description";
    public static final String EMBED_CODE_TAG = "EmbedCode";
    public static final String GROUP_TAG = "Group";
    public static final String ID_ATTRIBUTE = "id";
    public static final String ID_TAG = "ID";
    public static final String LANGUAGE_TAG = "Language";
    public static final String MESSAGE_TAG = "Message";
    public static final String NAME_TAG = "name";
    public static final String PERMALINK_TAG = "Permalink";
    public static final String PLAYER_DOC_TAG = "PlayerDoc";
    public static final String RELATED_SLIDESHOWS_TAG = "RelatedSlideshows";
    public static final String SLIDESHOWS_TAG = "Slideshows";
    public static final String SLIDESHOW_ID_TAG = "SlideShowID";
    public static final String SLIDESHOW_TAG = "Slideshow";
    public static final String SLIDESHOW_UPLOADED_TAG = "SlideShowUploaded";
    public static final String SLIDESHOW_DELETED_TAG = "SlideShowDeleted";
    public static final String STATUS_DESCRIPTION_TAG = "StatusDescription";
    public static final String STATUS_TAG = "Status";
    public static final String TAG_TAG = "Tag";
    public static final String TAGS_TAG = "Tags";
    public static final String THUMBNAIL_TAG = "Thumbnail";
    public static final String THUMBNAIL_URL_TAG = "ThumbnailURL";
    public static final String THUMBNAIL_SMALL_URL_TAG = "ThumbnailSmallURL";
    public static final String TITLE_TAG = "Title";
    public static final String TOTAL_SLIDES_TAG = "TotalSlides";
    public static final String USER_TAG = "User";
    public static final String USER_ID_TAG = "UserID";
    public static final String USER_LOGIN_TAG = "UserLogin";
    public static final String URL_TAG = "URL";
    public static final String URL_DOC_TAG = "URLDoc";
    public static final String VIEWS_TAG = "Views";
    private StringBuilder tempVal = new StringBuilder();
    private Slideshow tempSlideshow;
    private List<Slideshow> tempSlideshows;
    private User tempUser;
    private Tag tempTag;
    private Group tempGroup;
    private String tempId;
    private String tempName;
    private int tempCount;
    private String tempSlideShowId;
    private DocumentParserResult parserResult;
    private SlideshowInfo tempSlideshowInfo;

    private DocumentParser() {
    }

    public static DocumentParserResult parse(InputStream is) throws IOException {
        DocumentParser documentParser = new DocumentParser();
        documentParser.parseDocument(is);
        is.close();
        return documentParser.parserResult;
    }

    private void parseDocument(InputStream is) {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        try {
            SAXParser sp = spf.newSAXParser();
            sp.parse(is, (DefaultHandler)this);
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.tempVal.setLength(0);
        if (qName.equalsIgnoreCase(SLIDESHOW_TAG)) {
            this.tempSlideshow = new Slideshow();
            this.tempSlideshowInfo = new SlideshowInfo();
        } else if (qName.equalsIgnoreCase(SLIDESHOWS_TAG)) {
            this.tempSlideshows = new LinkedList<Slideshow>();
        } else if (qName.equalsIgnoreCase(USER_TAG)) {
            this.tempUser = new User();
            this.tempSlideshows = new LinkedList<Slideshow>();
        } else if (qName.equalsIgnoreCase(TAG_TAG)) {
            this.tempTag = new Tag();
            this.tempSlideshows = new LinkedList<Slideshow>();
        } else if (qName.equalsIgnoreCase(GROUP_TAG)) {
            this.tempGroup = new Group();
            this.tempSlideshows = new LinkedList<Slideshow>();
        } else if (qName.equalsIgnoreCase(MESSAGE_TAG)) {
            this.tempId = attributes.getValue(ID_ATTRIBUTE);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.tempVal.append(ch, start, length);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase(SLIDESHOW_TAG)) {
            if (this.tempSlideshowInfo.getUrl() != null) {
                this.createResult();
                this.parserResult.setSlideShowInfo(this.tempSlideshowInfo);
            } else {
                this.tempSlideshows.add(this.tempSlideshow);
            }
        } else if (qName.equalsIgnoreCase(SLIDESHOWS_TAG)) {
            this.createResult();
            if (!this.tempSlideshows.isEmpty()) {
                this.parserResult.setSlideShows(this.tempSlideshows);
            }
        } else if (qName.equalsIgnoreCase(USER_TAG)) {
            this.tempUser.setName(this.tempName);
            this.tempUser.setCount(this.tempCount);
            this.tempUser.setSlideshows(this.tempSlideshows);
            this.createResult();
            this.parserResult.setUser(this.tempUser);
        } else if (qName.equalsIgnoreCase(TAG_TAG)) {
            this.tempTag.setName(this.tempName);
            this.tempTag.setCount(this.tempCount);
            this.tempTag.setSlideshows(this.tempSlideshows);
            this.createResult();
            this.parserResult.setTag(this.tempTag);
        } else if (qName.equalsIgnoreCase(GROUP_TAG)) {
            this.tempGroup.setName(this.tempName);
            this.tempGroup.setCount(this.tempCount);
            this.tempGroup.setSlideshows(this.tempSlideshows);
            this.createResult();
            this.parserResult.setGroup(this.tempGroup);
        } else if (qName.equalsIgnoreCase(SLIDESHOW_UPLOADED_TAG)) {
            this.createResult();
            this.parserResult.setSlideShowId(this.tempSlideShowId);
        } else if (qName.equalsIgnoreCase(SLIDESHOW_DELETED_TAG)) {
            this.createResult();
            this.parserResult.setSlideShowId(this.tempSlideShowId);
        } else {
            if (qName.equalsIgnoreCase(MESSAGE_TAG)) {
                throw new SlideShareException(this.secureParseInt(this.tempId, -1), this.tempVal.toString());
            }
            if (qName.equalsIgnoreCase(STATUS_TAG)) {
                this.tempSlideshow.setStatus(this.secureParseInt(this.tempVal.toString(), -1));
                this.tempSlideshowInfo.setStatus(this.secureParseInt(this.tempVal.toString(), -1));
            } else if (qName.equalsIgnoreCase(STATUS_DESCRIPTION_TAG)) {
                this.tempSlideshow.setStatusDescription(this.tempVal.toString());
            } else if (qName.equalsIgnoreCase(TITLE_TAG)) {
                this.tempSlideshow.setTitle(this.tempVal.toString());
                this.tempSlideshowInfo.setTitle(this.tempVal.toString());
            } else if (qName.equalsIgnoreCase(DESCRIPTION_TAG)) {
                this.tempSlideshow.setDescription(this.tempVal.toString());
                this.tempSlideshowInfo.setDescription(this.tempVal.toString());
            } else if (qName.equalsIgnoreCase(TAGS_TAG)) {
                this.tempSlideshow.setTags(this.tempVal.toString());
                this.tempSlideshowInfo.setTags(this.tempVal.toString());
            } else if (qName.equalsIgnoreCase(EMBED_CODE_TAG)) {
                this.tempSlideshow.setEmbedCode(this.tempVal.toString());
                this.tempSlideshowInfo.setEmbedCode(this.tempVal.toString());
            } else if (qName.equalsIgnoreCase(THUMBNAIL_TAG)) {
                this.tempSlideshow.setThumbnail(this.tempVal.toString());
            } else if (qName.equalsIgnoreCase(PERMALINK_TAG)) {
                this.tempSlideshow.setPermalink(this.tempVal.toString());
            } else if (qName.equalsIgnoreCase(VIEWS_TAG)) {
                this.tempSlideshow.setViews(this.secureParseInt(this.tempVal.toString(), 0));
            } else if (qName.equalsIgnoreCase(NAME_TAG)) {
                this.tempName = this.tempVal.toString();
            } else if (qName.equalsIgnoreCase(COUNT_TAG)) {
                this.tempCount = this.secureParseInt(this.tempVal.toString(), -1);
            } else if (qName.equalsIgnoreCase(SLIDESHOW_ID_TAG)) {
                this.tempSlideShowId = this.tempVal.toString();
            } else if (qName.equals(ID_TAG)) {
                this.tempSlideshowInfo.setId(this.tempVal.toString());
            } else if (qName.equals(PLAYER_DOC_TAG)) {
                this.tempSlideshowInfo.setPlayerDoc(this.tempVal.toString());
            } else if (qName.equalsIgnoreCase(TOTAL_SLIDES_TAG)) {
                this.tempSlideshowInfo.setTotalSlides(this.secureParseInt(this.tempVal.toString(), 0));
            } else if (qName.equals(URL_DOC_TAG)) {
                this.tempSlideshowInfo.setUrlDoc(this.tempVal.toString());
            } else if (qName.equals(LANGUAGE_TAG)) {
                this.tempSlideshowInfo.setLanguage(this.tempVal.toString());
            } else if (qName.equals(URL_TAG)) {
                this.tempSlideshowInfo.setUrl(this.tempVal.toString());
            } else if (qName.equals(USER_ID_TAG)) {
                this.tempSlideshowInfo.setUserId(this.tempVal.toString());
            } else if (qName.equals(USER_LOGIN_TAG)) {
                this.tempSlideshowInfo.setUserLogin(this.tempVal.toString());
            } else if (qName.equals(RELATED_SLIDESHOWS_TAG)) {
                this.tempSlideshowInfo.setRelatedSlideshows(this.tempVal.toString());
            } else if (qName.equals(THUMBNAIL_URL_TAG)) {
                this.tempSlideshowInfo.setThumbnailUrl(this.tempVal.toString());
            } else if (qName.equals(THUMBNAIL_SMALL_URL_TAG)) {
                this.tempSlideshowInfo.setThumbnailSmallUrl(this.tempVal.toString());
            }
        }
    }

    private int secureParseInt(String value, int def) {
        int result = def;
        try {
            result = Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    private void createResult() {
        if (this.parserResult == null) {
            this.parserResult = new DocumentParserResult();
        }
    }
}

