/*
 * Decompiled with CFR 0.152.
 */
package com.benfante.jslideshare;

import com.benfante.jslideshare.DocumentParser;
import com.benfante.jslideshare.DocumentParserResult;
import com.benfante.jslideshare.SlideShareAPI;
import com.benfante.jslideshare.SlideShareConnector;
import com.benfante.jslideshare.SlideShareErrorException;
import com.benfante.jslideshare.SlideShareException;
import com.benfante.jslideshare.messages.Group;
import com.benfante.jslideshare.messages.Slideshow;
import com.benfante.jslideshare.messages.SlideshowInfo;
import com.benfante.jslideshare.messages.Tag;
import com.benfante.jslideshare.messages.User;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlideShareAPIImpl
implements SlideShareAPI {
    private static final Logger logger = Logger.getLogger(SlideShareAPIImpl.class);
    public static final String URL_GET_SLIDESHOW = "http://www.slideshare.net/api/1/get_slideshow";
    public static final String URL_GET_SLIDESHOW_INFO = "http://www.slideshare.net/api/1/get_slideshow_info";
    public static final String URL_GET_SLIDESHOW_BY_USER = "http://www.slideshare.net/api/1/get_slideshow_by_user";
    public static final String URL_GET_SLIDESHOW_BY_TAG = "http://www.slideshare.net/api/1/get_slideshow_by_tag";
    public static final String URL_GET_SLIDESHOW_BY_GROUP = "http://www.slideshare.net/api/1/get_slideshow_from_group";
    public static final String URL_UPLOAD_SLIDESHOW = "http://www.slideshare.net/api/1/upload_slideshow";
    public static final String URL_DELETE_SLIDESHOW = "http://www.slideshare.net/api/1/delete_slideshow";
    protected SlideShareConnector connector;

    public SlideShareAPIImpl() {
    }

    public SlideShareAPIImpl(SlideShareConnector connector) {
        this.connector = connector;
    }

    public SlideShareConnector getConnector() {
        return this.connector;
    }

    public void setConnector(SlideShareConnector connector) {
        this.connector = connector;
    }

    @Override
    public Slideshow getSlideshow(String id) throws SlideShareException, SlideShareErrorException {
        logger.info((Object)("Called getSlideshow with id=" + id));
        HashMap<String, String> parameters = new HashMap<String, String>();
        this.addParameter(parameters, "slideshow_id", id);
        return this.sendMessage(URL_GET_SLIDESHOW, parameters).getSlideShow();
    }

    @Override
    public SlideshowInfo getSlideshowInfo(String id, String url) throws SlideShareException, SlideShareErrorException {
        logger.info((Object)("Called getSlideshowInfo with id=" + id + ", url=" + url));
        HashMap<String, String> parameters = new HashMap<String, String>();
        this.addParameter(parameters, "slideshow_id", id);
        this.addParameter(parameters, "slideshow_url", url);
        return this.sendGetMessage(URL_GET_SLIDESHOW_INFO, parameters).getSlideShowInfo();
    }

    @Override
    public User getSlideshowByUser(String username) throws SlideShareException, SlideShareErrorException {
        logger.info((Object)("Called getSlideshowByUser with username=" + username));
        return this.getSlideshowByUser(username, -1, -1);
    }

    @Override
    public User getSlideshowByUser(String username, int offset, int limit) throws SlideShareException, SlideShareErrorException {
        logger.info((Object)("Called getSlideshowByUser with username=" + username + ", offset=" + offset + ", limit=" + limit));
        HashMap<String, String> parameters = new HashMap<String, String>();
        this.addParameter(parameters, "username_for", username);
        this.addLimits(parameters, offset, limit);
        return this.sendMessage(URL_GET_SLIDESHOW_BY_USER, parameters).getUser();
    }

    @Override
    public Tag getSlideshowByTag(String tag) throws SlideShareException, SlideShareErrorException {
        logger.info((Object)("Called getSlideshowByTag with tag=" + tag));
        return this.getSlideshowByTag(tag, -1, -1);
    }

    @Override
    public Tag getSlideshowByTag(String tag, int offset, int limit) throws SlideShareException, SlideShareErrorException {
        logger.info((Object)("Called getSlideshowByTag with tag=" + tag + ", offset=" + offset + ", limit=" + limit));
        HashMap<String, String> parameters = new HashMap<String, String>();
        this.addParameter(parameters, "tag", tag);
        this.addLimits(parameters, offset, limit);
        return this.sendMessage(URL_GET_SLIDESHOW_BY_TAG, parameters).getTag();
    }

    @Override
    public Group getSlideshowByGroup(String groupName) throws SlideShareException, SlideShareErrorException {
        logger.info((Object)("Called getSlideshowByGroup with groupName=" + groupName));
        return this.getSlideshowByGroup(groupName, -1, -1);
    }

    @Override
    public Group getSlideshowByGroup(String groupName, int offset, int limit) throws SlideShareException, SlideShareErrorException {
        logger.info((Object)("Called getSlideshowByGrop with groupName=" + groupName + ", offset=" + offset + ", limit=" + limit));
        HashMap<String, String> parameters = new HashMap<String, String>();
        this.addParameter(parameters, "group_name", groupName);
        this.addLimits(parameters, offset, limit);
        return this.sendMessage(URL_GET_SLIDESHOW_BY_GROUP, parameters).getGroup();
    }

    @Override
    public String uploadSlideshow(String username, String password, String title, File src, String description, String tags, boolean makeSrcPublic, boolean makeSlideshowPrivate, boolean generateSecretUrl, boolean allowEmbeds, boolean shareWithContacts) throws SlideShareException, SlideShareErrorException {
        logger.info((Object)("Called uploadSlideshow with username=" + username + ", password=XXX, title=" + title + ", description=" + description + ", tags=" + tags + ", makeSrcPublic=" + makeSrcPublic + ", makeSlideshowPrivate=" + makeSlideshowPrivate + ", generateSecretUrl=" + generateSecretUrl + ", allowEmbeds=" + allowEmbeds + ", shareWithContacts=" + shareWithContacts));
        HashMap<String, String> parameters = new HashMap<String, String>();
        this.addParameter(parameters, "username", username);
        this.addParameter(parameters, "password", password);
        this.addParameter(parameters, "slideshow_title", title);
        this.addParameter(parameters, "slideshow_description", description);
        this.addParameter(parameters, "slideshow_tags", tags);
        this.addParameter(parameters, "make_src_public", makeSrcPublic);
        this.addParameter(parameters, "make_slideshow_private", makeSlideshowPrivate);
        this.addParameter(parameters, "generate_secret_url", generateSecretUrl);
        this.addParameter(parameters, "allow_embeds", allowEmbeds);
        this.addParameter(parameters, "share_with_contacts", shareWithContacts);
        HashMap<String, File> files = new HashMap<String, File>();
        files.put("slideshow_srcfile", src);
        return this.sendMessage(URL_UPLOAD_SLIDESHOW, parameters, files).getSlideShowId();
    }

    private Map<String, String> addParameter(Map<String, String> parameters, String name, String value) {
        if (value != null) {
            parameters.put(name, value);
        }
        return parameters;
    }

    private Map<String, String> addParameter(Map<String, String> parameters, String name, boolean value) {
        parameters.put(name, value ? "Y" : "N");
        return parameters;
    }

    private Map<String, String> addLimits(Map<String, String> parameters, int offset, int limit) {
        if (offset >= 0) {
            parameters.put("offset", Integer.toString(offset));
        }
        if (limit >= 0) {
            parameters.put("limit", Integer.toString(limit));
        }
        return parameters;
    }

    private DocumentParserResult sendMessage(String url, Map<String, String> parameters) throws SlideShareErrorException {
        DocumentParserResult result;
        try {
            InputStream response = this.connector.sendMessage(url, parameters);
            result = DocumentParser.parse(response);
        }
        catch (IOException iOException) {
            throw new SlideShareErrorException(-1, "Error sending a message to the url " + url, iOException);
        }
        return result;
    }

    private DocumentParserResult sendGetMessage(String url, Map<String, String> parameters) throws SlideShareErrorException {
        DocumentParserResult result;
        try {
            InputStream response = this.connector.sendGetMessage(url, parameters);
            result = DocumentParser.parse(response);
        }
        catch (IOException iOException) {
            throw new SlideShareErrorException(-1, "Error sending a message to the url " + url, iOException);
        }
        return result;
    }

    private DocumentParserResult sendMessage(String url, Map<String, String> parameters, Map<String, File> files) throws SlideShareErrorException {
        DocumentParserResult result;
        try {
            InputStream response = this.connector.sendMultiPartMessage(url, parameters, files);
            result = DocumentParser.parse(response);
        }
        catch (IOException iOException) {
            throw new SlideShareErrorException(-1, "Error sending a multipart message to the url " + url, iOException);
        }
        return result;
    }
}

