/*
 * Decompiled with CFR 0.152.
 */
package com.benfante.jslideshare;

import com.benfante.jslideshare.SlideShareConnector;
import com.benfante.jslideshare.SlideShareErrorException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlideShareConnectorImpl
implements SlideShareConnector {
    private static final Logger logger = Logger.getLogger(SlideShareConnectorImpl.class);
    protected String apiKey;
    protected String sharedSecret;
    protected int soTimeout;
    protected String proxyHost;
    protected int proxyPort = -1;
    protected String proxyUsername;
    protected String proxyPassword;

    public SlideShareConnectorImpl() {
    }

    public SlideShareConnectorImpl(String apiKey, String sharedSecret) {
        this();
        this.apiKey = apiKey;
        this.sharedSecret = sharedSecret;
    }

    public SlideShareConnectorImpl(String apiKey, String sharedSecret, int soTimeout) {
        this(apiKey, sharedSecret);
        this.soTimeout = soTimeout;
    }

    public SlideShareConnectorImpl(String apiKey, String sharedSecret, int soTimeout, String proxyHost, int proxyPort, String proxyUsername, String proxyPassword) {
        this(apiKey, sharedSecret, soTimeout);
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getSharedSecret() {
        return this.sharedSecret;
    }

    public void setSharedSecret(String sharedSecret) {
        this.sharedSecret = sharedSecret;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    @Override
    public InputStream sendMessage(String url, Map<String, String> parameters) throws IOException, SlideShareErrorException {
        HttpClient client = this.createHttpClient();
        PostMethod method = new PostMethod(url);
        method.addParameter("api_key", this.apiKey);
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            method.addParameter(entry.getKey(), entry.getValue());
        }
        Date now = new Date();
        String ts = Long.toString(now.getTime() / 1000L);
        String hash = DigestUtils.shaHex((String)(this.sharedSecret + ts)).toLowerCase();
        method.addParameter("ts", ts);
        method.addParameter("hash", hash);
        logger.debug((Object)("Sending POST message to " + method.getURI().getURI() + " with parameters " + Arrays.toString(method.getParameters())));
        int statusCode = client.executeMethod((HttpMethod)method);
        if (statusCode != 200) {
            logger.debug((Object)("Server replied with a " + statusCode + " HTTP status code (" + HttpStatus.getStatusText((int)statusCode) + ")"));
            throw new SlideShareErrorException(statusCode, HttpStatus.getStatusText((int)statusCode));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)method.getResponseBodyAsString());
        }
        ByteArrayInputStream result = new ByteArrayInputStream(method.getResponseBody());
        method.releaseConnection();
        return result;
    }

    @Override
    public InputStream sendMultiPartMessage(String url, Map<String, String> parameters, Map<String, File> files) throws IOException, SlideShareErrorException {
        HttpClient client = this.createHttpClient();
        PostMethod method = new PostMethod(url);
        ArrayList<Object> partList = new ArrayList<Object>();
        partList.add(this.createStringPart("api_key", this.apiKey));
        Date now = new Date();
        String ts = Long.toString(now.getTime() / 1000L);
        String hash = DigestUtils.shaHex((String)(this.sharedSecret + ts)).toLowerCase();
        partList.add(this.createStringPart("ts", ts));
        partList.add(this.createStringPart("hash", hash));
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            partList.add(this.createStringPart(entry.getKey(), entry.getValue()));
        }
        for (Map.Entry<String, File> entry : files.entrySet()) {
            partList.add(this.createFilePart(entry.getKey(), entry.getValue()));
        }
        MultipartRequestEntity requestEntity = new MultipartRequestEntity(partList.toArray(new Part[partList.size()]), method.getParams());
        method.setRequestEntity((RequestEntity)requestEntity);
        logger.debug((Object)("Sending multipart POST message to " + method.getURI().getURI() + " with parts " + partList));
        int statusCode = client.executeMethod((HttpMethod)method);
        if (statusCode != 200) {
            logger.debug((Object)("Server replied with a " + statusCode + " HTTP status code (" + HttpStatus.getStatusText((int)statusCode) + ")"));
            throw new SlideShareErrorException(statusCode, HttpStatus.getStatusText((int)statusCode));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)method.getResponseBodyAsString());
        }
        ByteArrayInputStream result = new ByteArrayInputStream(method.getResponseBody());
        method.releaseConnection();
        return result;
    }

    @Override
    public InputStream sendGetMessage(String url, Map<String, String> parameters) throws IOException, SlideShareErrorException {
        HttpClient client = this.createHttpClient();
        GetMethod method = new GetMethod(url);
        Object[] params = new NameValuePair[parameters.size() + 3];
        int i = 0;
        params[i++] = new NameValuePair("api_key", this.apiKey);
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            params[i++] = new NameValuePair(entry.getKey(), entry.getValue());
        }
        Date now = new Date();
        String ts = Long.toString(now.getTime() / 1000L);
        String hash = DigestUtils.shaHex((String)(this.sharedSecret + ts)).toLowerCase();
        params[i++] = new NameValuePair("ts", ts);
        params[i++] = new NameValuePair("hash", hash);
        method.setQueryString((NameValuePair[])params);
        logger.debug((Object)("Sending GET message to " + method.getURI().getURI() + " with parameters " + Arrays.toString(params)));
        int statusCode = client.executeMethod((HttpMethod)method);
        if (statusCode != 200) {
            logger.debug((Object)("Server replied with a " + statusCode + " HTTP status code (" + HttpStatus.getStatusText((int)statusCode) + ")"));
            throw new SlideShareErrorException(statusCode, HttpStatus.getStatusText((int)statusCode));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)method.getResponseBodyAsString());
        }
        ByteArrayInputStream result = new ByteArrayInputStream(method.getResponseBody());
        method.releaseConnection();
        return result;
    }

    private StringPart createStringPart(String name, String value) {
        StringPart stringPart = new StringPart(name, value);
        stringPart.setContentType(null);
        stringPart.setTransferEncoding(null);
        stringPart.setCharSet("UTF-8");
        return stringPart;
    }

    private FilePart createFilePart(String name, File value) throws FileNotFoundException {
        FilePart filePart = new FilePart(name, value);
        filePart.setTransferEncoding(null);
        filePart.setCharSet(null);
        return filePart;
    }

    private HttpClient createHttpClient() {
        HttpClient client = new HttpClient();
        client.getParams().setSoTimeout(this.soTimeout);
        if (this.getProxyHost() != null) {
            client.getHostConfiguration().setProxy(this.proxyHost, this.proxyPort);
            if (this.proxyUsername != null && this.proxyPassword != null) {
                client.getState().setProxyCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.proxyUsername, this.proxyPassword));
            }
        }
        return client;
    }
}

