/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.connect.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.ConnectionFactoryLocator;
import org.springframework.social.connect.ConnectionKey;
import org.springframework.social.connect.ConnectionRepository;
import org.springframework.social.connect.ConnectionSignUp;
import org.springframework.social.connect.UsersConnectionRepository;
import org.springframework.social.connect.jdbc.JdbcConnectionRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcUsersConnectionRepository
implements UsersConnectionRepository {
    private final JdbcTemplate jdbcTemplate;
    private final ConnectionFactoryLocator connectionFactoryLocator;
    private final TextEncryptor textEncryptor;
    private ConnectionSignUp connectionSignUp;
    private String tablePrefix = "";

    public JdbcUsersConnectionRepository(DataSource dataSource, ConnectionFactoryLocator connectionFactoryLocator, TextEncryptor textEncryptor) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.connectionFactoryLocator = connectionFactoryLocator;
        this.textEncryptor = textEncryptor;
    }

    public void setConnectionSignUp(ConnectionSignUp connectionSignUp) {
        this.connectionSignUp = connectionSignUp;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    @Override
    public String findUserIdWithConnection(Connection<?> connection) {
        try {
            ConnectionKey key = connection.getKey();
            return (String)this.jdbcTemplate.queryForObject("select userId from " + this.tablePrefix + "UserConnection where providerId = ? and providerUserId = ?", String.class, new Object[]{key.getProviderId(), key.getProviderUserId()});
        }
        catch (IncorrectResultSizeDataAccessException e) {
            if (e.getActualSize() == 0 && this.connectionSignUp != null) {
                String newUserId = this.connectionSignUp.execute(connection);
                this.createConnectionRepository(newUserId).addConnection(connection);
                return newUserId;
            }
            return null;
        }
    }

    @Override
    public Set<String> findUserIdsConnectedTo(String providerId, Set<String> providerUserIds) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("providerId", (Object)providerId);
        parameters.addValue("providerUserIds", providerUserIds);
        final HashSet localUserIds = new HashSet();
        return (Set)new NamedParameterJdbcTemplate((JdbcOperations)this.jdbcTemplate).query("select userId from " + this.tablePrefix + "UserConnection where providerId = :providerId and providerUserId in (:providerUserIds)", (SqlParameterSource)parameters, (ResultSetExtractor)new ResultSetExtractor<Set<String>>(){

            public Set<String> extractData(ResultSet rs) throws SQLException, DataAccessException {
                while (rs.next()) {
                    localUserIds.add(rs.getString("userId"));
                }
                return localUserIds;
            }
        });
    }

    @Override
    public ConnectionRepository createConnectionRepository(String userId) {
        if (userId == null) {
            throw new IllegalArgumentException("userId cannot be null");
        }
        return new JdbcConnectionRepository(userId, this.jdbcTemplate, this.connectionFactoryLocator, this.textEncryptor, this.tablePrefix);
    }
}

