/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.connect.support;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.springframework.core.GenericTypeResolver;
import org.springframework.social.ExpiredAuthorizationException;
import org.springframework.social.ServiceProvider;
import org.springframework.social.connect.ApiAdapter;
import org.springframework.social.connect.ConnectionData;
import org.springframework.social.connect.support.AbstractConnection;
import org.springframework.social.oauth2.AccessGrant;
import org.springframework.social.oauth2.OAuth2ServiceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuth2Connection<A>
extends AbstractConnection<A> {
    private final OAuth2ServiceProvider<A> serviceProvider;
    private String accessToken;
    private String refreshToken;
    private Long expireTime;
    private A api;
    private A apiProxy;

    public OAuth2Connection(String providerId, String providerUserId, String accessToken, String refreshToken, Long expireTime, OAuth2ServiceProvider<A> serviceProvider, ApiAdapter<A> apiAdapter) {
        super(apiAdapter);
        this.serviceProvider = serviceProvider;
        this.initAccessTokens(accessToken, refreshToken, expireTime);
        this.initApi();
        this.initApiProxy();
        this.initKey(providerId, providerUserId);
    }

    public OAuth2Connection(ConnectionData data, OAuth2ServiceProvider<A> serviceProvider, ApiAdapter<A> apiAdapter) {
        super(data, apiAdapter);
        this.serviceProvider = serviceProvider;
        this.initAccessTokens(data.getAccessToken(), data.getRefreshToken(), data.getExpireTime());
        this.initApi();
        this.initApiProxy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasExpired() {
        Object object = this.getMonitor();
        synchronized (object) {
            return this.expireTime != null && System.currentTimeMillis() >= this.expireTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        Object object = this.getMonitor();
        synchronized (object) {
            AccessGrant accessGrant = this.serviceProvider.getOAuthOperations().refreshAccess(this.refreshToken, null, null);
            this.initAccessTokens(accessGrant.getAccessToken(), accessGrant.getRefreshToken(), accessGrant.getExpireTime());
            this.initApi();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public A getApi() {
        if (this.apiProxy != null) {
            return this.apiProxy;
        }
        Object object = this.getMonitor();
        synchronized (object) {
            return this.api;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionData createData() {
        Object object = this.getMonitor();
        synchronized (object) {
            return new ConnectionData(this.getKey().getProviderId(), this.getKey().getProviderUserId(), this.getDisplayName(), this.getProfileUrl(), this.getImageUrl(), this.accessToken, null, this.refreshToken, this.expireTime);
        }
    }

    private void initAccessTokens(String accessToken, String refreshToken, Long expireTime) {
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.expireTime = expireTime;
    }

    private void initApi() {
        this.api = this.serviceProvider.getApi(this.accessToken);
    }

    private void initApiProxy() {
        Class apiType = GenericTypeResolver.resolveTypeArgument(this.serviceProvider.getClass(), ServiceProvider.class);
        if (apiType.isInterface()) {
            this.apiProxy = Proxy.newProxyInstance(apiType.getClassLoader(), new Class[]{apiType}, (InvocationHandler)new ApiInvocationHandler());
        }
    }

    private class ApiInvocationHandler
    implements InvocationHandler {
        private ApiInvocationHandler() {
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object object = OAuth2Connection.this.getMonitor();
            synchronized (object) {
                if (OAuth2Connection.this.hasExpired()) {
                    throw new ExpiredAuthorizationException();
                }
                try {
                    return method.invoke(OAuth2Connection.this.api, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
        }
    }
}

