/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.connect.support;

import org.springframework.social.connect.ApiAdapter;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.ConnectionData;
import org.springframework.social.connect.ConnectionFactory;
import org.springframework.social.connect.support.OAuth2Connection;
import org.springframework.social.oauth2.AccessGrant;
import org.springframework.social.oauth2.OAuth2Operations;
import org.springframework.social.oauth2.OAuth2ServiceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuth2ConnectionFactory<S>
extends ConnectionFactory<S> {
    public OAuth2ConnectionFactory(String providerId, OAuth2ServiceProvider<S> serviceProvider, ApiAdapter<S> apiAdapter) {
        super(providerId, serviceProvider, apiAdapter);
    }

    public OAuth2Operations getOAuthOperations() {
        return this.getOAuth2ServiceProvider().getOAuthOperations();
    }

    public Connection<S> createConnection(AccessGrant accessGrant) {
        return new OAuth2Connection<S>(this.getProviderId(), this.extractProviderUserId(accessGrant), accessGrant.getAccessToken(), accessGrant.getRefreshToken(), accessGrant.getExpireTime(), this.getOAuth2ServiceProvider(), this.getApiAdapter());
    }

    @Override
    public Connection<S> createConnection(ConnectionData data) {
        return new OAuth2Connection<S>(data, this.getOAuth2ServiceProvider(), this.getApiAdapter());
    }

    protected String extractProviderUserId(AccessGrant accessGrant) {
        return null;
    }

    private OAuth2ServiceProvider<S> getOAuth2ServiceProvider() {
        return (OAuth2ServiceProvider)this.getServiceProvider();
    }
}

