/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.oauth1;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJacksonHttpMessageConverter;
import org.springframework.social.ApiBinding;
import org.springframework.social.oauth1.OAuth1Credentials;
import org.springframework.social.oauth1.ProtectedResourceClientFactory;
import org.springframework.social.support.ClientHttpRequestFactorySelector;
import org.springframework.web.client.RestTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOAuth1ApiBinding
implements ApiBinding {
    private final OAuth1Credentials credentials;
    private final RestTemplate restTemplate;

    protected AbstractOAuth1ApiBinding() {
        this.credentials = null;
        this.restTemplate = new RestTemplate(ClientHttpRequestFactorySelector.getRequestFactory());
        this.restTemplate.setMessageConverters(this.getMessageConverters());
    }

    protected AbstractOAuth1ApiBinding(String consumerKey, String consumerSecret, String accessToken, String accessTokenSecret) {
        this.credentials = new OAuth1Credentials(consumerKey, consumerSecret, accessToken, accessTokenSecret);
        this.restTemplate = ProtectedResourceClientFactory.create(this.credentials);
        this.restTemplate.setMessageConverters(this.getMessageConverters());
    }

    public void setRequestFactory(ClientHttpRequestFactory requestFactory) {
        if (this.isAuthorized()) {
            this.restTemplate.setRequestFactory(ProtectedResourceClientFactory.addOAuthSigning(requestFactory, this.credentials));
        } else {
            this.restTemplate.setRequestFactory(requestFactory);
        }
    }

    @Override
    public boolean isAuthorized() {
        return this.credentials != null;
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    protected List<HttpMessageConverter<?>> getMessageConverters() {
        ArrayList messageConverters = new ArrayList();
        messageConverters.add((HttpMessageConverter<?>)new StringHttpMessageConverter());
        FormHttpMessageConverter formHttpMessageConverter = new FormHttpMessageConverter();
        formHttpMessageConverter.setCharset(Charset.forName("UTF-8"));
        messageConverters.add((HttpMessageConverter<?>)formHttpMessageConverter);
        messageConverters.add((HttpMessageConverter<?>)new MappingJacksonHttpMessageConverter());
        return messageConverters;
    }
}

