/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.oauth1;

import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.social.oauth1.OAuth1Credentials;
import org.springframework.social.oauth1.OAuth1RequestInterceptor;
import org.springframework.social.oauth1.Spring30OAuth1RequestFactory;
import org.springframework.social.support.ClientHttpRequestFactorySelector;
import org.springframework.util.ClassUtils;
import org.springframework.web.client.RestTemplate;

class ProtectedResourceClientFactory {
    private static boolean interceptorsSupported = ClassUtils.isPresent((String)"org.springframework.http.client.ClientHttpRequestInterceptor", (ClassLoader)ProtectedResourceClientFactory.class.getClassLoader());

    ProtectedResourceClientFactory() {
    }

    public static RestTemplate create(OAuth1Credentials credentials) {
        RestTemplate client = new RestTemplate(ClientHttpRequestFactorySelector.getRequestFactory());
        if (interceptorsSupported) {
            client.setInterceptors(new ClientHttpRequestInterceptor[]{new OAuth1RequestInterceptor(credentials)});
        } else {
            client.setRequestFactory((ClientHttpRequestFactory)new Spring30OAuth1RequestFactory(client.getRequestFactory(), credentials));
        }
        return client;
    }

    public static ClientHttpRequestFactory addOAuthSigning(ClientHttpRequestFactory requestFactory, OAuth1Credentials credentials) {
        if (interceptorsSupported) {
            return requestFactory;
        }
        return new Spring30OAuth1RequestFactory(requestFactory, credentials);
    }
}

