/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.oauth2;

import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.social.oauth2.OAuth2RequestInterceptor;
import org.springframework.social.oauth2.OAuth2Version;
import org.springframework.social.oauth2.Spring30OAuth2RequestFactory;
import org.springframework.social.support.ClientHttpRequestFactorySelector;
import org.springframework.util.ClassUtils;
import org.springframework.web.client.RestTemplate;

class ProtectedResourceClientFactory {
    private static boolean interceptorsSupported = ClassUtils.isPresent((String)"org.springframework.http.client.ClientHttpRequestInterceptor", (ClassLoader)ProtectedResourceClientFactory.class.getClassLoader());

    ProtectedResourceClientFactory() {
    }

    public static RestTemplate create(String accessToken, OAuth2Version version) {
        RestTemplate client = new RestTemplate(ClientHttpRequestFactorySelector.getRequestFactory());
        if (interceptorsSupported) {
            client.setInterceptors(new ClientHttpRequestInterceptor[]{new OAuth2RequestInterceptor(accessToken, version)});
        } else {
            client.setRequestFactory((ClientHttpRequestFactory)new Spring30OAuth2RequestFactory(client.getRequestFactory(), accessToken, version));
        }
        return client;
    }

    public static ClientHttpRequestFactory addOAuthSigning(ClientHttpRequestFactory requestFactory, String accessToken, OAuth2Version version) {
        if (interceptorsSupported) {
            return requestFactory;
        }
        return new Spring30OAuth2RequestFactory(requestFactory, accessToken, version);
    }
}

