/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.support;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.social.support.AbstractBufferingClientHttpRequest;
import org.springframework.social.support.BufferingClientHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;

class BufferingClientHttpRequest
extends AbstractBufferingClientHttpRequest {
    private final ClientHttpRequest request;

    BufferingClientHttpRequest(ClientHttpRequest request) {
        Assert.notNull((Object)request, (String)"'request' must not be null");
        this.request = request;
    }

    public HttpMethod getMethod() {
        return this.request.getMethod();
    }

    public URI getURI() {
        return this.request.getURI();
    }

    protected ClientHttpResponse executeInternal(HttpHeaders headers, byte[] bufferedOutput) throws IOException {
        this.request.getHeaders().putAll((Map)headers);
        OutputStream body = this.request.getBody();
        FileCopyUtils.copy((byte[])bufferedOutput, (OutputStream)body);
        ClientHttpResponse response = this.request.execute();
        return new BufferingClientHttpResponse(response);
    }
}

