/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.support;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.social.support.URIBuilderException;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URIBuilder {
    private final String baseUri;
    private MultiValueMap<String, String> parameters;

    private URIBuilder(String baseUri) {
        this.baseUri = baseUri;
        this.parameters = new LinkedMultiValueMap();
    }

    public static URIBuilder fromUri(String baseUri) {
        return new URIBuilder(baseUri);
    }

    public URIBuilder queryParam(String name, String value) {
        this.parameters.add((Object)name, (Object)value);
        return this;
    }

    public URIBuilder queryParams(MultiValueMap<String, String> params) {
        this.parameters.putAll(params);
        return this;
    }

    public URI build() {
        try {
            StringBuilder builder = new StringBuilder();
            Set entrySet = this.parameters.entrySet();
            Iterator entryIt = entrySet.iterator();
            while (entryIt.hasNext()) {
                Map.Entry entry = (Map.Entry)entryIt.next();
                String name = (String)entry.getKey();
                List values = (List)entry.getValue();
                Iterator valueIt = values.iterator();
                while (valueIt.hasNext()) {
                    String value = (String)valueIt.next();
                    builder.append(this.formEncode(name)).append("=");
                    if (value != null) {
                        builder.append(this.formEncode(value));
                    }
                    if (!valueIt.hasNext()) continue;
                    builder.append("&");
                }
                if (!entryIt.hasNext()) continue;
                builder.append("&");
            }
            return new URI(this.baseUri + (builder.length() > 0 ? "?" + builder.toString() : ""));
        }
        catch (URISyntaxException e) {
            throw new URIBuilderException("Unable to build URI: Bad URI syntax", e);
        }
    }

    private String formEncode(String data) {
        try {
            return URLEncoder.encode(data, "UTF-8");
        }
        catch (UnsupportedEncodingException wontHappen) {
            throw new IllegalStateException(wontHappen);
        }
    }
}

