/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.wrapper;

import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.AuthenticationTrustResolver;
import net.sf.acegisecurity.AuthenticationTrustResolverImpl;
import net.sf.acegisecurity.UserDetails;
import net.sf.acegisecurity.context.ContextHolder;
import net.sf.acegisecurity.context.security.SecureContext;
import net.sf.acegisecurity.context.security.SecureContextUtils;

public class ContextHolderAwareRequestWrapper
extends HttpServletRequestWrapper {
    private AuthenticationTrustResolver authenticationTrustResolver = new AuthenticationTrustResolverImpl();

    public ContextHolderAwareRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public String getRemoteUser() {
        Authentication auth = this.getAuthentication();
        if (auth == null || auth.getPrincipal() == null) {
            return null;
        }
        if (auth.getPrincipal() instanceof UserDetails) {
            return ((UserDetails)auth.getPrincipal()).getUsername();
        }
        return auth.getPrincipal().toString();
    }

    public boolean isUserInRole(String role) {
        return this.isGranted(role);
    }

    public Principal getUserPrincipal() {
        Authentication auth = this.getAuthentication();
        if (auth == null || auth.getPrincipal() == null) {
            return null;
        }
        return auth;
    }

    private Authentication getAuthentication() {
        Authentication auth;
        if (ContextHolder.getContext() != null && ContextHolder.getContext() instanceof SecureContext && !this.authenticationTrustResolver.isAnonymous(auth = SecureContextUtils.getSecureContext().getAuthentication())) {
            return auth;
        }
        return null;
    }

    private boolean isGranted(String role) {
        Authentication auth = this.getAuthentication();
        if (auth == null || auth.getPrincipal() == null || auth.getAuthorities() == null) {
            return false;
        }
        for (int i = 0; i < auth.getAuthorities().length; ++i) {
            if (!role.equals(auth.getAuthorities()[i].getAuthority())) continue;
            return true;
        }
        return false;
    }
}

