/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter.api.impl;

import java.util.List;
import java.util.Map;
import org.springframework.social.twitter.api.FriendOperations;
import org.springframework.social.twitter.api.TwitterProfile;
import org.springframework.social.twitter.api.impl.AbstractTwitterOperations;
import org.springframework.social.twitter.api.impl.LongIdsList;
import org.springframework.social.twitter.api.impl.TwitterProfileUsersList;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FriendTemplate
extends AbstractTwitterOperations
implements FriendOperations {
    private final RestTemplate restTemplate;
    private static final MultiValueMap<String, Object> EMPTY_DATA = new LinkedMultiValueMap();

    public FriendTemplate(RestTemplate restTemplate, boolean isAuthorizedForUser) {
        super(isAuthorizedForUser);
        this.restTemplate = restTemplate;
    }

    @Override
    public List<TwitterProfile> getFriends() {
        this.requireAuthorization();
        return ((TwitterProfileUsersList)this.restTemplate.getForObject(this.buildUri("statuses/friends.json", "cursor", "-1"), TwitterProfileUsersList.class)).getList();
    }

    @Override
    public List<TwitterProfile> getFriends(long userId) {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.set((Object)"cursor", (Object)"-1");
        parameters.set((Object)"user_id", (Object)String.valueOf(userId));
        return ((TwitterProfileUsersList)this.restTemplate.getForObject(this.buildUri("statuses/friends.json", (MultiValueMap<String, String>)parameters), TwitterProfileUsersList.class)).getList();
    }

    @Override
    public List<TwitterProfile> getFriends(String screenName) {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.set((Object)"cursor", (Object)"-1");
        parameters.set((Object)"screen_name", (Object)screenName);
        return ((TwitterProfileUsersList)this.restTemplate.getForObject(this.buildUri("statuses/friends.json", (MultiValueMap<String, String>)parameters), TwitterProfileUsersList.class)).getList();
    }

    @Override
    public List<Long> getFriendIds() {
        this.requireAuthorization();
        return ((LongIdsList)this.restTemplate.getForObject(this.buildUri("friends/ids.json", "cursor", "-1"), LongIdsList.class)).getList();
    }

    @Override
    public List<Long> getFriendIds(long userId) {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.set((Object)"cursor", (Object)"-1");
        parameters.set((Object)"user_id", (Object)String.valueOf(userId));
        return ((LongIdsList)this.restTemplate.getForObject(this.buildUri("friends/ids.json", (MultiValueMap<String, String>)parameters), LongIdsList.class)).getList();
    }

    @Override
    public List<Long> getFriendIds(String screenName) {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.set((Object)"cursor", (Object)"-1");
        parameters.set((Object)"screen_name", (Object)screenName);
        return ((LongIdsList)this.restTemplate.getForObject(this.buildUri("friends/ids.json", (MultiValueMap<String, String>)parameters), LongIdsList.class)).getList();
    }

    @Override
    public List<TwitterProfile> getFollowers() {
        this.requireAuthorization();
        return ((TwitterProfileUsersList)this.restTemplate.getForObject(this.buildUri("statuses/followers.json", "cursor", "-1"), TwitterProfileUsersList.class)).getList();
    }

    @Override
    public List<TwitterProfile> getFollowers(long userId) {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.set((Object)"cursor", (Object)"-1");
        parameters.set((Object)"user_id", (Object)String.valueOf(userId));
        return ((TwitterProfileUsersList)this.restTemplate.getForObject(this.buildUri("statuses/followers.json", (MultiValueMap<String, String>)parameters), TwitterProfileUsersList.class)).getList();
    }

    @Override
    public List<TwitterProfile> getFollowers(String screenName) {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.set((Object)"cursor", (Object)"-1");
        parameters.set((Object)"screen_name", (Object)screenName);
        return ((TwitterProfileUsersList)this.restTemplate.getForObject(this.buildUri("statuses/followers.json", (MultiValueMap<String, String>)parameters), TwitterProfileUsersList.class)).getList();
    }

    @Override
    public List<Long> getFollowerIds() {
        this.requireAuthorization();
        return ((LongIdsList)this.restTemplate.getForObject(this.buildUri("followers/ids.json", "cursor", "-1"), LongIdsList.class)).getList();
    }

    @Override
    public List<Long> getFollowerIds(long userId) {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.set((Object)"cursor", (Object)"-1");
        parameters.set((Object)"user_id", (Object)String.valueOf(userId));
        return ((LongIdsList)this.restTemplate.getForObject(this.buildUri("followers/ids.json", (MultiValueMap<String, String>)parameters), LongIdsList.class)).getList();
    }

    @Override
    public List<Long> getFollowerIds(String screenName) {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.set((Object)"cursor", (Object)"-1");
        parameters.set((Object)"screen_name", (Object)screenName);
        return ((LongIdsList)this.restTemplate.getForObject(this.buildUri("followers/ids.json", (MultiValueMap<String, String>)parameters), LongIdsList.class)).getList();
    }

    @Override
    public String follow(long userId) {
        this.requireAuthorization();
        return (String)((Map)this.restTemplate.postForObject(this.buildUri("friendships/create.json", "user_id", String.valueOf(userId)), EMPTY_DATA, Map.class)).get("screen_name");
    }

    @Override
    public String follow(String screenName) {
        this.requireAuthorization();
        return (String)((Map)this.restTemplate.postForObject(this.buildUri("friendships/create.json", "screen_name", screenName), EMPTY_DATA, Map.class)).get("screen_name");
    }

    @Override
    public String unfollow(long userId) {
        this.requireAuthorization();
        return (String)((Map)this.restTemplate.postForObject(this.buildUri("friendships/destroy.json", "user_id", String.valueOf(userId)), EMPTY_DATA, Map.class)).get("screen_name");
    }

    @Override
    public String unfollow(String screenName) {
        this.requireAuthorization();
        return (String)((Map)this.restTemplate.postForObject(this.buildUri("friendships/destroy.json", "screen_name", screenName), EMPTY_DATA, Map.class)).get("screen_name");
    }

    @Override
    public TwitterProfile enableNotifications(long userId) {
        this.requireAuthorization();
        return (TwitterProfile)this.restTemplate.postForObject(this.buildUri("notifications/follow.json", "user_id", String.valueOf(userId)), EMPTY_DATA, TwitterProfile.class);
    }

    @Override
    public TwitterProfile enableNotifications(String screenName) {
        this.requireAuthorization();
        return (TwitterProfile)this.restTemplate.postForObject(this.buildUri("notifications/follow.json", "screen_name", screenName), EMPTY_DATA, TwitterProfile.class);
    }

    @Override
    public TwitterProfile disableNotifications(long userId) {
        this.requireAuthorization();
        return (TwitterProfile)this.restTemplate.postForObject(this.buildUri("notifications/leave.json", "user_id", String.valueOf(userId)), EMPTY_DATA, TwitterProfile.class);
    }

    @Override
    public TwitterProfile disableNotifications(String screenName) {
        this.requireAuthorization();
        return (TwitterProfile)this.restTemplate.postForObject(this.buildUri("notifications/leave.json", "screen_name", screenName), EMPTY_DATA, TwitterProfile.class);
    }

    @Override
    public boolean friendshipExists(String userA, String userB) {
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.set((Object)"user_a", (Object)userA);
        params.set((Object)"user_b", (Object)userB);
        return (Boolean)this.restTemplate.getForObject(this.buildUri("friendships/exists.json", (MultiValueMap<String, String>)params), Boolean.TYPE);
    }

    @Override
    public List<Long> getIncomingFriendships() {
        this.requireAuthorization();
        return ((LongIdsList)this.restTemplate.getForObject(this.buildUri("friendships/incoming.json"), LongIdsList.class)).getList();
    }

    @Override
    public List<Long> getOutgoingFriendships() {
        this.requireAuthorization();
        return ((LongIdsList)this.restTemplate.getForObject(this.buildUri("friendships/outgoing.json"), LongIdsList.class)).getList();
    }
}

