/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter.api.impl;

import java.io.IOException;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.springframework.social.twitter.api.PlaceType;
import org.springframework.social.twitter.api.impl.PlaceTypeDeserializer;

@JsonIgnoreProperties(ignoreUnknown=true)
class PlaceMixin {
    @JsonCreator
    public PlaceMixin(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="full_name") String fullName, @JsonProperty(value="attributes") @JsonDeserialize(using=StreetAddressDeserializer.class) String streetAddress, @JsonProperty(value="country") String country, @JsonProperty(value="country_code") String countryCode, @JsonProperty(value="place_type") @JsonDeserialize(using=PlaceTypeDeserializer.class) PlaceType placeType) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StreetAddressDeserializer
    extends JsonDeserializer<String> {
        private StreetAddressDeserializer() {
        }

        public String deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode tree = jp.readValueAsTree();
            return tree.has("street_address") ? tree.get("street_address").getValueAsText() : null;
        }
    }
}

