/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter.api.impl;

import java.util.List;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJacksonHttpMessageConverter;
import org.springframework.social.oauth1.AbstractOAuth1ApiBinding;
import org.springframework.social.twitter.api.BlockOperations;
import org.springframework.social.twitter.api.DirectMessageOperations;
import org.springframework.social.twitter.api.FriendOperations;
import org.springframework.social.twitter.api.GeoOperations;
import org.springframework.social.twitter.api.ListOperations;
import org.springframework.social.twitter.api.SearchOperations;
import org.springframework.social.twitter.api.TimelineOperations;
import org.springframework.social.twitter.api.Twitter;
import org.springframework.social.twitter.api.UserOperations;
import org.springframework.social.twitter.api.impl.BlockTemplate;
import org.springframework.social.twitter.api.impl.DirectMessageTemplate;
import org.springframework.social.twitter.api.impl.FriendTemplate;
import org.springframework.social.twitter.api.impl.GeoTemplate;
import org.springframework.social.twitter.api.impl.ListTemplate;
import org.springframework.social.twitter.api.impl.SearchTemplate;
import org.springframework.social.twitter.api.impl.TimelineTemplate;
import org.springframework.social.twitter.api.impl.TwitterErrorHandler;
import org.springframework.social.twitter.api.impl.TwitterModule;
import org.springframework.social.twitter.api.impl.UserTemplate;
import org.springframework.web.client.ResponseErrorHandler;

public class TwitterTemplate
extends AbstractOAuth1ApiBinding
implements Twitter {
    private TimelineOperations timelineOperations;
    private UserOperations userOperations;
    private FriendOperations friendOperations;
    private ListOperations listOperations;
    private SearchOperations searchOperations;
    private DirectMessageOperations directMessageOperations;
    private BlockOperations blockOperations;
    private GeoOperations geoOperations;

    public TwitterTemplate() {
        this.registerTwitterJsonModule();
        this.getRestTemplate().setErrorHandler((ResponseErrorHandler)new TwitterErrorHandler());
        this.initSubApis();
    }

    public TwitterTemplate(String consumerKey, String consumerSecret, String accessToken, String accessTokenSecret) {
        super(consumerKey, consumerSecret, accessToken, accessTokenSecret);
        this.registerTwitterJsonModule();
        this.getRestTemplate().setErrorHandler((ResponseErrorHandler)new TwitterErrorHandler());
        this.initSubApis();
    }

    public TimelineOperations timelineOperations() {
        return this.timelineOperations;
    }

    public FriendOperations friendOperations() {
        return this.friendOperations;
    }

    public ListOperations listOperations() {
        return this.listOperations;
    }

    public SearchOperations searchOperations() {
        return this.searchOperations;
    }

    public DirectMessageOperations directMessageOperations() {
        return this.directMessageOperations;
    }

    public UserOperations userOperations() {
        return this.userOperations;
    }

    public BlockOperations blockOperations() {
        return this.blockOperations;
    }

    public GeoOperations geoOperations() {
        return this.geoOperations;
    }

    private void registerTwitterJsonModule() {
        List converters = this.getRestTemplate().getMessageConverters();
        for (HttpMessageConverter converter : converters) {
            if (!(converter instanceof MappingJacksonHttpMessageConverter)) continue;
            MappingJacksonHttpMessageConverter jsonConverter = (MappingJacksonHttpMessageConverter)converter;
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.registerModule((Module)new TwitterModule());
            jsonConverter.setObjectMapper(objectMapper);
        }
    }

    private void initSubApis() {
        this.userOperations = new UserTemplate(this.getRestTemplate(), this.isAuthorized());
        this.directMessageOperations = new DirectMessageTemplate(this.getRestTemplate(), this.isAuthorized());
        this.friendOperations = new FriendTemplate(this.getRestTemplate(), this.isAuthorized());
        this.listOperations = new ListTemplate(this.getRestTemplate(), this.isAuthorized());
        this.timelineOperations = new TimelineTemplate(this.getRestTemplate(), this.isAuthorized());
        this.searchOperations = new SearchTemplate(this.getRestTemplate(), this.isAuthorized());
        this.blockOperations = new BlockTemplate(this.getRestTemplate(), this.isAuthorized());
        this.geoOperations = new GeoTemplate(this.getRestTemplate(), this.isAuthorized());
    }
}

