/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.bean;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.PackageDescriptionDocument;
import org.springframework.extensions.webscripts.Path;
import org.springframework.extensions.webscripts.Registry;
import org.springframework.extensions.webscripts.ResourceDescription;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.TypeDescription;
import org.springframework.extensions.webscripts.WebScript;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexPackageDoc
extends DeclarativeWebScript {
    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status) {
        WebScript[] webscripts;
        Map templateVars = req.getServiceMatch().getTemplateVars();
        String packagePath = "/" + (String)templateVars.get("package");
        Registry registry = this.getContainer().getRegistry();
        Path path = registry.getPackage(packagePath);
        if (path == null) {
            throw new WebScriptException(404, "Web Script Package '" + packagePath + "' not found");
        }
        PackageDescriptionDocument packageDoc = registry.getPackageDescriptionDocument(packagePath);
        if (packageDoc == null) {
            throw new WebScriptException(404, "Web Script documentation for package '" + packagePath + "' not found");
        }
        HashMap<String, TypeDescription> schemas = new HashMap<String, TypeDescription>();
        WebScript[] webScriptArray = webscripts = path.getScripts();
        int n = webscripts.length;
        int n2 = 0;
        while (n2 < n) {
            TypeDescription[] responses;
            int n3;
            WebScript webscript = webScriptArray[n2];
            TypeDescription[] requests = webscript.getDescription().getRequestTypes();
            if (requests != null) {
                TypeDescription[] typeDescriptionArray = requests;
                n3 = requests.length;
                int n4 = 0;
                while (n4 < n3) {
                    TypeDescription request = typeDescriptionArray[n4];
                    if (request.getId() != null) {
                        schemas.put(request.getId(), request);
                    }
                    ++n4;
                }
            }
            if ((responses = webscript.getDescription().getResponseTypes()) != null) {
                TypeDescription[] typeDescriptionArray = responses;
                int n5 = responses.length;
                n3 = 0;
                while (n3 < n5) {
                    TypeDescription response = typeDescriptionArray[n3];
                    if (response.getId() != null) {
                        schemas.put(response.getId(), response);
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        ArrayList<WebScript> unmappedWebScripts = new ArrayList<WebScript>(Arrays.asList(webscripts));
        ResourceDescription[] resources = packageDoc.getResourceDescriptions();
        if (resources != null) {
            ResourceDescription[] resourceDescriptionArray = resources;
            int n6 = resources.length;
            int n7 = 0;
            while (n7 < n6) {
                String[] scriptIds;
                ResourceDescription resource = resourceDescriptionArray[n7];
                String[] stringArray = scriptIds = resource.getScriptIds();
                int n8 = scriptIds.length;
                int n9 = 0;
                while (n9 < n8) {
                    String scriptId = stringArray[n9];
                    WebScript webscript = registry.getWebScript(scriptId);
                    if (webscript != null) {
                        unmappedWebScripts.remove(webscript);
                    }
                    ++n9;
                }
                ++n7;
            }
        }
        HashMap<String, Object> model = new HashMap<String, Object>(7, 1.0f);
        model.put("registry", registry);
        model.put("package", path);
        model.put("packagedoc", packageDoc);
        model.put("schemas", schemas.values());
        model.put("unmapped", unmappedWebScripts);
        return model;
    }
}

