/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.directives;

import freemarker.core.Environment;
import freemarker.template.SimpleHash;
import freemarker.template.SimpleScalar;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONArray;
import org.springframework.extensions.directives.DependencyDirectiveData;
import org.springframework.extensions.directives.JavaScriptDependencyDirective;
import org.springframework.extensions.directives.OutputCSSContentModelElement;
import org.springframework.extensions.surf.DojoDependencies;
import org.springframework.extensions.surf.DojoDependencyHandler;
import org.springframework.extensions.surf.I18nDependencyHandler;
import org.springframework.extensions.surf.extensibility.DeferredContentTargetModelElement;
import org.springframework.extensions.surf.extensibility.ExtensibilityDirectiveData;
import org.springframework.extensions.surf.extensibility.ExtensibilityModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateDojoPageDirective
extends JavaScriptDependencyDirective {
    public static final String DIRECTIVE_NAME = "createDojoPage";
    public static final String MODEL_KEY = "dojoPageConfig";
    public static final String WIDGET_NAME = "name";
    public static final String WIDGET_CONFIG = "configObj";
    public static final String WIDGETS_LIST = "widgets";
    private DojoDependencyHandler dojoDependencyHandler = null;
    private I18nDependencyHandler i18nDependencyHandler = null;

    public CreateDojoPageDirective(String directiveName, ExtensibilityModel model) {
        super(directiveName, model);
    }

    public void setDojoDependencyHandler(DojoDependencyHandler dojoDependencyHandler) {
        this.dojoDependencyHandler = dojoDependencyHandler;
    }

    public void setI18nDependencyHandler(I18nDependencyHandler i18nDependencyHandler) {
        this.i18nDependencyHandler = i18nDependencyHandler;
    }

    @Override
    public ExtensibilityDirectiveData createExtensibilityDirectiveData(String id, String action, String target, Map params, TemplateDirectiveBody body, Environment env) throws TemplateException {
        TemplateHashModel model = env.getDataModel();
        String group = this.getStringProperty(params, "group", false);
        String servicesJSONStr = "";
        List services = null;
        String widgetsJSONStr = "";
        List widgets = null;
        TemplateModel o = model.get(MODEL_KEY);
        if (o instanceof SimpleHash) {
            SimpleHash pageConfig = (SimpleHash)o;
            if ((o = pageConfig.get("services")) instanceof SimpleSequence) {
                services = ((SimpleSequence)o).toList();
                servicesJSONStr = JSONArray.toJSONString((List)services);
            }
            if ((o = pageConfig.get(WIDGETS_LIST)) instanceof SimpleSequence) {
                widgets = ((SimpleSequence)o).toList();
                widgetsJSONStr = JSONArray.toJSONString((List)widgets);
            }
        }
        String checksum = null;
        LinkedHashMap<String, DojoDependencies> dependenciesForCurrentRequest = new LinkedHashMap<String, DojoDependencies>();
        String pagePath = this.dojoDependencyHandler.getPath(null, this.getWebFrameworkConfig().getDojoPageWidget()) + ".js";
        DojoDependencies pageDeps = this.dojoDependencyHandler.getDependencies(pagePath);
        this.dojoDependencyHandler.recursivelyProcessDependencies(pageDeps, dependenciesForCurrentRequest);
        String domReadyPath = this.dojoDependencyHandler.getPath(null, "dojo/domReady") + ".js";
        DojoDependencies domReadyDeps = this.dojoDependencyHandler.getDependencies(domReadyPath);
        dependenciesForCurrentRequest.put(domReadyPath, domReadyDeps);
        this.dojoDependencyHandler.recursivelyProcessDependencies(domReadyDeps, dependenciesForCurrentRequest);
        if (services != null) {
            for (String service : services) {
                String servicePath = this.dojoDependencyHandler.getPath(null, service) + ".js";
                DojoDependencies serviceDeps = this.dojoDependencyHandler.getDependencies(servicePath);
                dependenciesForCurrentRequest.put(servicePath, serviceDeps);
                this.dojoDependencyHandler.recursivelyProcessDependencies(serviceDeps, dependenciesForCurrentRequest);
            }
        }
        this.processControllerWidgets(widgets, dependenciesForCurrentRequest);
        if (this.getWebFrameworkConfig().isAggregateDependenciesEnabled() || this.isForceAggregation()) {
            String aggregatedOutput = this.dojoDependencyHandler.outputAggregateResource(dependenciesForCurrentRequest, null);
            try {
                InputStream in = this.dependencyHandler.getResourceInputStream(pagePath);
                if (in != null) {
                    aggregatedOutput = aggregatedOutput + "\n\n" + this.dependencyHandler.convertResourceToString(in);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            checksum = this.dojoDependencyHandler.getChecksumPathForDependencies(aggregatedOutput);
        }
        String prefix = this.dependencyAggregator.getServletContext().getContextPath() + this.dependencyHandler.getResourceControllerMapping() + "/";
        OutputCSSContentModelElement outputCss = null;
        DeferredContentTargetModelElement te = this.getModel().getDeferredContent("outputCSSDependenciesDirective", "outputCSS");
        if (te instanceof OutputCSSContentModelElement) {
            outputCss = (OutputCSSContentModelElement)te;
            for (Map.Entry depEntry : dependenciesForCurrentRequest.entrySet()) {
                DojoDependencies currDep = (DojoDependencies)depEntry.getValue();
                if (currDep == null || outputCss == null) continue;
                for (DojoDependencies.CssDependency cssDep : ((DojoDependencies)depEntry.getValue()).getCssDeps()) {
                    if (this.getWebFrameworkConfig().isAggregateDependenciesEnabled() || this.isForceAggregation()) {
                        ((OutputCSSContentModelElement)te).addCSSDependency(cssDep.getPath(), cssDep.getMediaType(), group);
                        continue;
                    }
                    ((OutputCSSContentModelElement)te).addCSSDependency(prefix + cssDep.getPath(), cssDep.getMediaType(), group);
                }
            }
        }
        String content = this.buildJavaScriptForPage(checksum, servicesJSONStr, widgetsJSONStr, dependenciesForCurrentRequest, model);
        DeferredContentTargetModelElement targetElement = this.getModel().getDeferredContent("outputJavaScriptDirective", "outputJavaScript");
        DependencyDirectiveData directiveData = new DependencyDirectiveData(id, action, target, this.getDirectiveName(), body, env, content, group, targetElement);
        return directiveData;
    }

    protected String buildJavaScriptForPage(String checksum, String servicesJSONStr, String widgetsJSONStr, Map<String, DojoDependencies> dependenciesForCurrentRequest, TemplateHashModel model) {
        StringBuilder content = new StringBuilder(">>>");
        content.append(this.i18nDependencyHandler.generateI18nJavaScript(dependenciesForCurrentRequest));
        try {
            String messages = "";
            TemplateModel _messages = model.get("messages");
            if (_messages instanceof SimpleScalar) {
                messages = ((SimpleScalar)_messages).toString();
                content.append(this.getWebFrameworkConfig().getDojoMessagesObject());
                content.append(".messages.pageScope = ");
                content.append(messages);
                content.append(";\n");
            }
        }
        catch (TemplateModelException e) {
            // empty catch block
        }
        if (this.getWebFrameworkConfig().isDojoLoaderTraceEnabled()) {
            content.append("require.trace.set(\"loader-inject\", 1);\nrequire.trace.set(\"loader-define\", 0);\n");
        }
        content.append("require(['");
        if (this.getWebFrameworkConfig().isAggregateDependenciesEnabled() || this.isForceAggregation()) {
            content.append(checksum.substring(3, checksum.length() - 3));
        } else {
            content.append(this.getWebFrameworkConfig().getDojoPageWidget());
            content.append("','dojo/domReady!");
        }
        content.append("'], function(Page) {\n var p = new Page({services:");
        content.append(servicesJSONStr);
        content.append(",widgets:");
        content.append(widgetsJSONStr);
        content.append("\n}, 'content');\n});\n");
        return content.toString();
    }

    protected void processControllerWidgets(List widgets, Map<String, DojoDependencies> dependenciesForCurrentRequest) {
        if (widgets != null) {
            for (Object w : widgets) {
                Object l;
                Object m;
                if (!(w instanceof Map)) continue;
                Map map = (Map)w;
                Object s = map.get(WIDGET_NAME);
                if (s instanceof String) {
                    String widgetPath = this.dojoDependencyHandler.getPath(null, (String)s) + ".js";
                    DojoDependencies widgetDeps = this.dojoDependencyHandler.getDependencies(widgetPath);
                    dependenciesForCurrentRequest.put(widgetPath, widgetDeps);
                    this.dojoDependencyHandler.recursivelyProcessDependencies(widgetDeps, dependenciesForCurrentRequest);
                }
                if (!((m = map.get(WIDGET_CONFIG)) instanceof Map) || !((l = ((Map)m).get(WIDGETS_LIST)) instanceof List)) continue;
                this.processControllerWidgets((List)l, dependenciesForCurrentRequest);
            }
        }
    }
}

