/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.directives;

import java.util.ArrayList;
import java.util.List;
import org.springframework.extensions.surf.extensibility.DeferredContentSourceModelElement;
import org.springframework.extensions.surf.extensibility.DeferredContentTargetModelElement;
import org.springframework.extensions.surf.extensibility.impl.DefaultContentModelElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DependencyDeferredContentTargetModelElement
extends DefaultContentModelElement
implements DeferredContentTargetModelElement {
    private List<DeferredContentSourceModelElement> sourceElements = new ArrayList<DeferredContentSourceModelElement>();
    private int editMode = -1;
    private List<DeferredContentSourceModelElement> sourceElementsBeingEdited = new ArrayList<DeferredContentSourceModelElement>();

    public DependencyDeferredContentTargetModelElement(String id, String directiveName) {
        super(id, directiveName);
    }

    public List<DeferredContentSourceModelElement> getSourceElements() {
        return this.sourceElements;
    }

    public void registerDeferredSourceElement(DeferredContentSourceModelElement sourceElement) {
        if (this.editMode == -1) {
            this.sourceElements.add(sourceElement);
        } else {
            this.sourceElements.add(this.editMode, sourceElement);
            ++this.editMode;
        }
    }

    public void enterEditMode(String mode, DeferredContentSourceModelElement sourceElement) {
        int indexOfEditedElement = this.sourceElements.indexOf(sourceElement);
        if (indexOfEditedElement != -1) {
            this.sourceElementsBeingEdited.add(sourceElement);
            if (mode == "after") {
                if (indexOfEditedElement > this.editMode) {
                    this.editMode = indexOfEditedElement + 1;
                }
            } else if (this.editMode < indexOfEditedElement) {
                this.editMode = indexOfEditedElement;
            }
        }
    }

    public void exitEditMode() {
        this.editMode = -1;
        this.sourceElementsBeingEdited.clear();
    }
}

