/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.directives;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.directives.CssDependencyContentModelElement;
import org.springframework.extensions.directives.DependencyDeferredContentTargetModelElement;
import org.springframework.extensions.surf.DependencyAggregator;
import org.springframework.extensions.surf.extensibility.DeferredContentSourceModelElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputCSSContentModelElement
extends DependencyDeferredContentTargetModelElement {
    private static final String TYPE = "DependencyContent";
    private DependencyAggregator dependencyAggregator;
    private String resourceControllerMapping;
    private WebFrameworkConfigElement webFrameworkConfig;
    private boolean forceAggregatedOutput = false;
    private LinkedHashMap<String, HashMap<String, LinkedHashSet<String>>> cssGroupToDependencyMap = new LinkedHashMap();

    public OutputCSSContentModelElement(String id, String directiveName, DependencyAggregator dependencyAggregator, WebFrameworkConfigElement webFrameworkConfig) {
        super(id, directiveName);
        this.dependencyAggregator = dependencyAggregator;
        this.webFrameworkConfig = webFrameworkConfig;
        this.resourceControllerMapping = this.dependencyAggregator.getServletContext().getContextPath() + "/res/";
    }

    public OutputCSSContentModelElement(String id, String directiveName, DependencyAggregator dependencyAggregator, WebFrameworkConfigElement webFrameworkConfig, boolean forceAggregatedOutput) {
        this(id, directiveName, dependencyAggregator, webFrameworkConfig);
        this.forceAggregatedOutput = forceAggregatedOutput;
    }

    public String getType() {
        return TYPE;
    }

    public void addCSSDependency(String fileName, String mediaType, String group) {
        LinkedHashSet<String> cssDependencies;
        HashMap<String, LinkedHashSet<String>> mediaToDependencyMap = this.cssGroupToDependencyMap.get(group);
        if (mediaToDependencyMap == null) {
            mediaToDependencyMap = new HashMap();
            this.cssGroupToDependencyMap.put(group, mediaToDependencyMap);
        }
        if ((cssDependencies = mediaToDependencyMap.get(mediaType)) == null) {
            cssDependencies = new LinkedHashSet();
            mediaToDependencyMap.put(mediaType, cssDependencies);
        }
        cssDependencies.add(fileName);
    }

    public String flushContent() {
        StringBuilder content = new StringBuilder();
        for (DeferredContentSourceModelElement sourceElement : this.getSourceElements()) {
            if (!(sourceElement instanceof CssDependencyContentModelElement)) continue;
            CssDependencyContentModelElement dependency = (CssDependencyContentModelElement)sourceElement;
            this.addCSSDependency(dependency.getDependency(), dependency.getMedia(), dependency.getGroup());
        }
        content.append((CharSequence)this.generateCSSDependencies(this.cssGroupToDependencyMap));
        return content.toString();
    }

    private StringBuilder generateCSSDependencies(LinkedHashMap<String, HashMap<String, LinkedHashSet<String>>> cssMap) {
        StringBuilder cssDeps = new StringBuilder();
        for (HashMap<String, LinkedHashSet<String>> group : cssMap.values()) {
            for (Map.Entry<String, LinkedHashSet<String>> mediaToCssResource : group.entrySet()) {
                if (this.webFrameworkConfig.isAggregateDependenciesEnabled() || this.forceAggregatedOutput) {
                    String checksum = this.dependencyAggregator.generateCSSDependencies(mediaToCssResource.getValue());
                    this.appendCSSLink(cssDeps, this.resourceControllerMapping + checksum, mediaToCssResource.getKey());
                    continue;
                }
                cssDeps.append("   <style type=\"text/css\" media=\"");
                cssDeps.append(mediaToCssResource.getKey());
                cssDeps.append("\">\n");
                for (String cssResource : mediaToCssResource.getValue()) {
                    cssDeps.append("      @import url(\"");
                    cssDeps.append(cssResource);
                    cssDeps.append("\");\n");
                }
                cssDeps.append("   </style>\n\n");
            }
        }
        return cssDeps;
    }

    private void appendCSSLink(StringBuilder cssDeps, String file, String media) {
        cssDeps.append("   <link rel=\"stylesheet\" type=\"text/css\" href=\"");
        cssDeps.append(file);
        cssDeps.append("\" media=\"");
        cssDeps.append(media);
        cssDeps.append("\">\n");
    }
}

