/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.directives;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.directives.DependencyDeferredContentSourceModelElement;
import org.springframework.extensions.directives.DependencyDeferredContentTargetModelElement;
import org.springframework.extensions.surf.DependencyAggregator;
import org.springframework.extensions.surf.extensibility.DeferredContentSourceModelElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputJavaScriptContentModelElement
extends DependencyDeferredContentTargetModelElement {
    private static final Log logger = LogFactory.getLog(OutputJavaScriptContentModelElement.class);
    private String requestPrefix = null;
    private DependencyAggregator dependencyAggregator;
    private WebFrameworkConfigElement webFrameworkConfig;
    private static final String TYPE = "DependencyContent";
    private boolean forceAggregatedOutput = false;
    private LinkedHashMap<String, LinkedHashSet<String>> javaScriptFiles = new LinkedHashMap();

    public OutputJavaScriptContentModelElement(String id, String directiveName, DependencyAggregator dependencyAggregator, WebFrameworkConfigElement webFrameworkConfig) {
        super(id, directiveName);
        this.dependencyAggregator = dependencyAggregator;
        this.webFrameworkConfig = webFrameworkConfig;
        this.requestPrefix = this.dependencyAggregator.getServletContext().getContextPath() + "/res/";
    }

    public OutputJavaScriptContentModelElement(String id, String directiveName, DependencyAggregator dependencyAggregator, WebFrameworkConfigElement webFrameworkConfig, boolean forceAggregatedOutput) {
        this(id, directiveName, dependencyAggregator, webFrameworkConfig);
        this.forceAggregatedOutput = forceAggregatedOutput;
    }

    public String getType() {
        return TYPE;
    }

    protected void addJavaScriptFile(String fileName, String groupName) {
        LinkedHashSet<String> group = this.javaScriptFiles.get(groupName);
        if (group == null) {
            group = new LinkedHashSet();
            this.javaScriptFiles.put(groupName, group);
        }
        group.add(fileName);
    }

    protected void addInlineJavaScriptForAggregation(String script, String groupName) {
        this.addJavaScriptFile(">>>" + script, groupName);
    }

    public String flushContent() {
        StringBuilder content = new StringBuilder();
        for (DeferredContentSourceModelElement sourceElement : this.getSourceElements()) {
            if (!(sourceElement instanceof DependencyDeferredContentSourceModelElement)) continue;
            DependencyDeferredContentSourceModelElement dependency = (DependencyDeferredContentSourceModelElement)sourceElement;
            this.addJavaScriptFile(dependency.getDependency(), dependency.getGroup());
        }
        content.append((CharSequence)this.generateJavaScriptDependencies(this.javaScriptFiles));
        return content.toString();
    }

    protected StringBuilder generateJavaScriptDependencies(HashMap<String, LinkedHashSet<String>> dependencies) {
        StringBuilder jsDeps = new StringBuilder();
        for (Map.Entry<String, LinkedHashSet<String>> entry : dependencies.entrySet()) {
            if (this.webFrameworkConfig.isAggregateDependenciesEnabled() || this.forceAggregatedOutput) {
                String checksum = this.dependencyAggregator.generateJavaScriptDependencies(entry.getValue());
                this.appendJavaScriptDependency(jsDeps, this.requestPrefix + checksum, entry.getKey());
                continue;
            }
            for (String javaScript : entry.getValue()) {
                if (javaScript == null) continue;
                if (javaScript.startsWith(">>>")) {
                    jsDeps.append("   <script type=\"text/javascript\">//<![CDATA[\n");
                    jsDeps.append(javaScript.substring(">>>".length()));
                    jsDeps.append("//]]></script>\n");
                    continue;
                }
                jsDeps.append("   <script type=\"text/javascript\" src=\"");
                jsDeps.append(javaScript);
                jsDeps.append("\"></script>");
                jsDeps.append("\n");
            }
        }
        return jsDeps;
    }

    protected void appendJavaScriptDependency(StringBuilder jsDeps, String src, String group) {
        jsDeps.append("   <script type=\"text/javascript\" src=\"");
        jsDeps.append(src);
        jsDeps.append("\"></script>");
        if (group != null) {
            jsDeps.append(" <!-- Group Name: \"");
            jsDeps.append(group);
            jsDeps.append("\" -->");
        }
        jsDeps.append("\n");
    }

    public WebFrameworkConfigElement getWebFrameworkConfig() {
        return this.webFrameworkConfig;
    }

    public String getRequestPrefix() {
        return this.requestPrefix;
    }

    public DependencyAggregator getDependencyAggregator() {
        return this.dependencyAggregator;
    }
}

