/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.directives;

import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.directives.DirectiveUtils;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.extensibility.impl.DefaultExtensibilityDirectiveData;
import org.springframework.extensions.surf.extensibility.impl.ModelWriter;
import org.springframework.extensions.surf.render.RenderFocus;
import org.springframework.extensions.surf.render.RenderService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegionDirectiveData
extends DefaultExtensibilityDirectiveData {
    private static final Log logger = LogFactory.getLog(RegionDirectiveData.class);
    public static final String REGION_ID = "id";
    public static final String CHROME_ID = "chrome";
    public static final String SCOPE_ID = "scope";
    public static final String CHROMELESS = "chromeless";
    private String regionId;
    private String scope;
    private String chromeId;
    private String templateId;
    private RenderService renderService;
    private RequestContext context;
    private boolean chromeless = false;

    public RegionDirectiveData(String id, String action, String target, String directiveName, Map<String, Object> params, RenderService renderService, RequestContext context, TemplateDirectiveBody body, Environment env) throws TemplateException {
        super(id, action, target, directiveName, body, env);
        this.regionId = DirectiveUtils.getStringProperty(params, REGION_ID, "region", true);
        this.scope = DirectiveUtils.getStringProperty(params, SCOPE_ID, "region", false);
        this.templateId = DirectiveUtils.getStringProperty(params, context.getTemplateId(), "region", false);
        if (this.scope == null) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("A scope was not provided for region: '" + this.regionId + "' when processing templateId: '" + this.templateId + "' - setting global scope to prevent NPE"));
            }
            this.scope = "global";
        }
        this.chromeId = DirectiveUtils.getStringProperty(params, CHROME_ID, "region", false);
        this.chromeless = DirectiveUtils.getBooleanProperty(params, CHROMELESS, "region", false);
        this.renderService = renderService;
        this.context = context;
    }

    public void render(ModelWriter writer) throws TemplateException, IOException {
        this.renderService.renderRegion(this.context, RenderFocus.BODY, this.templateId, this.regionId, this.scope, this.chromeId, this.chromeless);
    }
}

