/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.DependencyHandler;
import org.springframework.extensions.surf.util.Base64;

public class CssImageDataHandler {
    private static final Log logger = LogFactory.getLog(DependencyHandler.class);
    public static final String DATA_PREFIX_PART1 = "data:image/";
    public static final String DATA_PREFIX_PART2 = ";base64,";
    public static final String URL_OPEN_TARGET_PATTERN = "url(";
    public static final String URL_CLOSE_TARGET_PATTERN = ")";
    public static final String FORWARD_SLASH = "/";
    public static final String FULL_STOP = ".";
    public static final String DOUBLE_FULL_STOP = "..";
    public static final String DOUBLE_QUOTES = "\"";
    public static final String SINGLE_QUOTE = "'";
    public static final String DOUBLE_FULL_STOP_SLASH = "../";
    private DependencyHandler dependencyHandler;
    private ReentrantReadWriteLock encodedImageCacheLock = new ReentrantReadWriteLock();
    private Map<String, String> encodedImageCache = new HashMap<String, String>();
    public static final String MISSING_IMAGE_SENTINENEL = "";
    protected ThreadLocal<byte[]> streamBuffer = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[16384];
        }
    };

    public void setDependencyHandler(DependencyHandler dependencyHandler) {
        this.dependencyHandler = dependencyHandler;
    }

    public void processCssImages(String cssPath, StringBuilder cssContents) throws IOException {
        String pathPrefix = cssPath.substring(0, cssPath.lastIndexOf(FORWARD_SLASH));
        int index = cssContents.indexOf(URL_OPEN_TARGET_PATTERN);
        while (index != -1) {
            int matchingClose = cssContents.indexOf(URL_CLOSE_TARGET_PATTERN, index + URL_OPEN_TARGET_PATTERN.length());
            if (matchingClose == -1) {
                return;
            }
            String imageSrc = cssContents.substring(index + URL_OPEN_TARGET_PATTERN.length(), matchingClose).trim();
            if (imageSrc.startsWith(DOUBLE_QUOTES) || imageSrc.startsWith(SINGLE_QUOTE)) {
                imageSrc = imageSrc.substring(1);
            }
            if (imageSrc.endsWith(DOUBLE_QUOTES) || imageSrc.endsWith(SINGLE_QUOTE)) {
                imageSrc = imageSrc.substring(0, imageSrc.length() - 1);
            }
            if (imageSrc.startsWith(FULL_STOP) && !imageSrc.startsWith(DOUBLE_FULL_STOP)) {
                imageSrc = imageSrc.substring(1);
            }
            String mimetype = null;
            int extIndex = imageSrc.lastIndexOf(FULL_STOP);
            if (extIndex != -1) {
                mimetype = imageSrc.substring(extIndex + 1);
            }
            if (mimetype != null && !mimetype.equalsIgnoreCase("css")) {
                StringBuilder sb = new StringBuilder(pathPrefix);
                if (!imageSrc.startsWith(FORWARD_SLASH)) {
                    sb.append(FORWARD_SLASH);
                }
                sb.append(imageSrc);
                String encodedImage = this.getEncodedImage(sb.toString());
                if (encodedImage != null) {
                    int offset = index + URL_OPEN_TARGET_PATTERN.length();
                    cssContents.delete(offset, matchingClose);
                    offset = this.insert(cssContents, offset, DATA_PREFIX_PART1);
                    offset = this.insert(cssContents, offset, mimetype);
                    offset = this.insert(cssContents, offset, DATA_PREFIX_PART2);
                    offset = this.insert(cssContents, offset, encodedImage);
                    index = cssContents.indexOf(URL_OPEN_TARGET_PATTERN, offset);
                    continue;
                }
                index = cssContents.indexOf(URL_OPEN_TARGET_PATTERN, matchingClose);
                continue;
            }
            index = cssContents.indexOf(URL_OPEN_TARGET_PATTERN, matchingClose);
        }
    }

    public int insert(StringBuilder toUpdate, int offset, String toInsert) {
        toUpdate.insert(offset, toInsert);
        return offset + toInsert.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getEncodedImage(String path) {
        String encodedImage = null;
        this.encodedImageCacheLock.readLock().lock();
        try {
            encodedImage = this.encodedImageCache.get(path);
        }
        finally {
            this.encodedImageCacheLock.readLock().unlock();
        }
        if (encodedImage == null) {
            this.encodedImageCacheLock.writeLock().lock();
            try {
                encodedImage = this.encodedImageCache.get(path);
                if (encodedImage != null) return encodedImage;
                InputStream in = this.dependencyHandler.getResourceInputStream(path);
                if (in != null) {
                    encodedImage = this.encodeImage(in);
                }
                if (encodedImage != null) {
                    this.encodedImageCache.put(path, encodedImage);
                    return encodedImage;
                }
                if (in != null) return encodedImage;
                this.encodedImageCache.put(path, MISSING_IMAGE_SENTINENEL);
                return encodedImage;
            }
            catch (IOException e) {
                logger.error((Object)("The following error occurred attempting to Base64 encode \"" + path + "\": "), (Throwable)e);
                return encodedImage;
            }
            finally {
                this.encodedImageCacheLock.writeLock().unlock();
            }
        } else {
            if (encodedImage != MISSING_IMAGE_SENTINENEL) return encodedImage;
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String encodeImage(InputStream in) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Base64.OutputStream base64Out = new Base64.OutputStream((OutputStream)baos, 9);
        try {
            int byteCount;
            byte[] buffer = this.streamBuffer.get();
            while ((byteCount = in.read(buffer)) != -1) {
                base64Out.write(buffer, 0, byteCount);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ex) {}
            try {
                base64Out.close();
            }
            catch (IOException ex) {}
        }
        return baos.toString();
    }
}

