/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.config.element.GenericConfigElement;
import org.springframework.extensions.surf.CssImageDataHandler;
import org.springframework.extensions.webscripts.ScriptConfigModel;
import org.springframework.util.ClassUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.ServletContextResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyHandler
implements ApplicationContextAware {
    public static final String CSS = ".css";
    private static final Log logger = LogFactory.getLog(DependencyHandler.class);
    private String charset;
    private String digest;
    private ApplicationContext applicationContext = null;
    private ServletContext servletContext = null;
    private ScriptConfigModel scriptConfigModel;
    private CssImageDataHandler cssDataImageHandler;
    private WebFrameworkConfigElement webFrameworkConfigElement;
    private String resourceControllerMapping = "";
    private final Map<String, String> cachedChecksumPaths = new HashMap<String, String>(30);
    private final Map<String, String> cachedChecksums = new HashMap<String, String>(30);
    private final ReadWriteLock checksumPathsLock = new ReentrantReadWriteLock();
    private final ReadWriteLock checksumsLock = new ReentrantReadWriteLock();
    private Boolean isDebugMode = null;
    public static final String FLAGS = "flags";
    public static final String CLIENT_DEBUG = "client-debug";
    private List<String> debugSuffices;
    private List<String> productionSuffices;
    private final Map<String, ResourceInfo> cachedResourceInfoMap = new HashMap<String, ResourceInfo>();
    private final ReadWriteLock resourceInfoLock = new ReentrantReadWriteLock();
    private static ResourceInfoSentinel RESOURCE_INFO_SENTINEL = null;

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setDigest(String digest) {
        this.digest = digest;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        if (applicationContext instanceof WebApplicationContext) {
            this.servletContext = ((WebApplicationContext)applicationContext).getServletContext();
        }
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setScriptConfigModel(ScriptConfigModel scriptConfigModel) {
        this.scriptConfigModel = scriptConfigModel;
    }

    public void setCssDataImageHandler(CssImageDataHandler cssDataImageHandler) {
        this.cssDataImageHandler = cssDataImageHandler;
    }

    public void setWebFrameworkConfigElement(WebFrameworkConfigElement webFrameworkConfigElement) {
        this.webFrameworkConfigElement = webFrameworkConfigElement;
    }

    public String getResourceControllerMapping() {
        return this.resourceControllerMapping;
    }

    public void setResourceControllerMapping(String resourceControllerMapping) {
        this.resourceControllerMapping = resourceControllerMapping;
    }

    public boolean isDebugMode() {
        if (this.isDebugMode == null) {
            this.isDebugMode = this.getDebugFlag(CLIENT_DEBUG, Boolean.FALSE);
        }
        return this.isDebugMode;
    }

    private Boolean getDebugFlag(String element, Boolean defaultValue) {
        ConfigElement clientDebugElement;
        Object flags;
        Boolean debugValue = defaultValue;
        Map global = this.scriptConfigModel.getGlobal();
        if (global != null && (flags = global.get(FLAGS)) instanceof GenericConfigElement && (clientDebugElement = ((GenericConfigElement)flags).getChild(element)) != null) {
            debugValue = Boolean.valueOf(clientDebugElement.getValue());
        }
        return debugValue;
    }

    public void setDebugSuffices(List<String> debugSuffices) {
        this.debugSuffices = debugSuffices;
    }

    public void setProductionSuffices(List<String> productionSuffices) {
        this.productionSuffices = productionSuffices;
    }

    public List<String> generatePathsForClientMode(String path) {
        List<String> paths = null;
        if (this.isDebugMode() && this.debugSuffices != null) {
            paths = this.generatePathForSuffices(path, this.debugSuffices);
        } else if (!this.isDebugMode() && this.productionSuffices != null) {
            paths = this.generatePathForSuffices(path, this.productionSuffices);
        }
        if (paths == null) {
            paths = new ArrayList<String>(1);
            paths.add(path);
        }
        return paths;
    }

    private List<String> generatePathForSuffices(String path, List<String> suffices) {
        ArrayList<String> paths = null;
        int lastDotIndex = path.lastIndexOf(".");
        if (lastDotIndex != -1) {
            paths = new ArrayList<String>(suffices.size());
            for (String suffix : suffices) {
                String generatedPath = path.substring(0, lastDotIndex) + suffix + path.substring(lastDotIndex);
                paths.add(generatedPath);
            }
        }
        return paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceInfo getCachedResourceInfo(String path) {
        ResourceInfo resource = null;
        this.resourceInfoLock.readLock().lock();
        try {
            resource = this.cachedResourceInfoMap.get(path);
        }
        finally {
            this.resourceInfoLock.readLock().unlock();
        }
        return resource;
    }

    public InputStream getUnmodifiedResourceInputStream(String path) throws IOException {
        InputStream in = this.getResourceInputStream(path);
        if (in != null) {
            ResourceInfo resourceInfo = this.getCachedResourceInfo(path);
            in = resourceInfo.loadInputStream();
        }
        return in;
    }

    public InputStream getResourceInputStream(String path) throws IOException {
        InputStream in = null;
        ResourceInfo resourceInfo = this.getCachedResourceInfo(path);
        if (resourceInfo != this.getResourceInfoSentinel()) {
            if (resourceInfo != null) {
                in = resourceInfo.getInputStream();
            } else {
                String currPath;
                List<String> pathsToCheck = this.generatePathsForClientMode(path);
                Iterator<String> paths = pathsToCheck.iterator();
                while (in == null && paths.hasNext()) {
                    currPath = paths.next();
                    Resource r = this.applicationContext.getResource("classpath*:" + currPath);
                    if (r == null || !r.exists()) continue;
                    this.addResourceInfoToCache(path, new ApplicationContextResource(currPath));
                    in = this.getCachedResourceInfo(path).getInputStream();
                }
                paths = pathsToCheck.iterator();
                while (in == null && paths.hasNext()) {
                    currPath = paths.next();
                    URL resourceUrl = ClassUtils.getDefaultClassLoader().getResource("META-INF/" + currPath);
                    if (resourceUrl == null) continue;
                    this.addResourceInfoToCache(path, new ClassLoaderResource(currPath));
                    in = this.getCachedResourceInfo(path).getInputStream();
                }
                paths = pathsToCheck.iterator();
                while (this.servletContext != null && in == null && paths.hasNext()) {
                    ServletContextResource resource;
                    String p = paths.next();
                    String tmp = p;
                    if (!tmp.startsWith("/")) {
                        tmp = "/" + tmp;
                    }
                    if (!(resource = new ServletContextResource(this.servletContext, tmp)).exists()) continue;
                    this.addResourceInfoToCache(path, new ServletContextRes(p));
                    in = this.getCachedResourceInfo(path).getInputStream();
                }
            }
        }
        if (in == null) {
            this.addResourceInfoToCache(path, this.getResourceInfoSentinel());
        }
        return in;
    }

    public String generateCheckSumPath(String path, String checksum) {
        int lastDotIndex = path.lastIndexOf(".");
        String checksumPath = lastDotIndex != -1 ? path.substring(0, lastDotIndex) + "_" + checksum + path.substring(lastDotIndex) : path + "_" + checksum;
        return checksumPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResourceInfoToCache(String path, ResourceInfo resourceInfo) throws IOException {
        InputStream in;
        String checksum = "";
        if (resourceInfo != this.getResourceInfoSentinel() && (checksum = this.lookupChecksumInCache(path)) == null && (in = resourceInfo.getInputStream()) != null) {
            String resourceContents = this.convertResourceToString(in);
            if (this.webFrameworkConfigElement.isGenerateCssDataImagesEnabled() && path.toLowerCase().endsWith(CSS)) {
                StringBuilder processedContents = new StringBuilder(resourceContents);
                this.cssDataImageHandler.processCssImages(path, processedContents);
                resourceInfo.setContents(processedContents.toString());
                resourceContents = processedContents.toString();
            }
            checksum = this.generateCheckSum(resourceContents);
            this.addChecksumToCache(path, checksum);
        }
        String checksumPath = this.generateCheckSumPath(path, checksum);
        this.addChecksumPathToCache(path, checksumPath);
        this.resourceInfoLock.writeLock().lock();
        try {
            this.cachedResourceInfoMap.put(path, resourceInfo);
            this.cachedResourceInfoMap.put(checksumPath, resourceInfo);
        }
        finally {
            this.resourceInfoLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String convertResourceToString(InputStream in) throws IOException {
        String s = null;
        if (in != null) {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[1024];
            try {
                int n;
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                while ((n = reader.read(buffer)) != -1) {
                    ((Writer)writer).write(buffer, 0, n);
                }
                s = ((Object)writer).toString();
            }
            finally {
                in.close();
            }
        }
        return s;
    }

    public String getChecksumPath(String path) {
        String checksumPath = this.lookupChecksumPathInCache(path);
        if (checksumPath == null) {
            try {
                this.getResourceInputStream(path);
                checksumPath = this.lookupChecksumPathInCache(path);
            }
            catch (IOException e) {
                logger.error((Object)"The following error occurred attempting to obtain a checksum path", (Throwable)e);
            }
        }
        return checksumPath;
    }

    public String getChecksum(String path) {
        String checksum = this.lookupChecksumInCache(path);
        if (checksum == null) {
            try {
                this.getResourceInputStream(path);
                checksum = this.lookupChecksumInCache(path);
            }
            catch (IOException e) {
                logger.error((Object)"The following error occurred attempting to obtain a checksum path", (Throwable)e);
            }
        }
        return checksum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String lookupChecksumPathInCache(String path) {
        String checksumPath = null;
        this.checksumPathsLock.readLock().lock();
        try {
            checksumPath = this.cachedChecksumPaths.get(path);
        }
        finally {
            this.checksumPathsLock.readLock().unlock();
        }
        return checksumPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String lookupChecksumInCache(String path) {
        String checksumPath = null;
        this.checksumsLock.readLock().lock();
        try {
            checksumPath = this.cachedChecksums.get(path);
        }
        finally {
            this.checksumsLock.readLock().unlock();
        }
        return checksumPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChecksumPathToCache(String path, String checksumPath) {
        this.checksumPathsLock.writeLock().lock();
        try {
            this.cachedChecksumPaths.put(path, checksumPath);
        }
        finally {
            this.checksumPathsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChecksumToCache(String path, String checksum) {
        this.checksumsLock.writeLock().lock();
        try {
            this.cachedChecksums.put(path, checksum);
        }
        finally {
            this.checksumsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCaches() {
        this.checksumsLock.writeLock().lock();
        try {
            this.cachedChecksums.clear();
        }
        finally {
            this.checksumsLock.writeLock().unlock();
        }
        this.resourceInfoLock.writeLock().lock();
        try {
            this.cachedResourceInfoMap.clear();
        }
        finally {
            this.resourceInfoLock.writeLock().unlock();
        }
        this.checksumPathsLock.writeLock().lock();
        try {
            this.cachedChecksumPaths.clear();
        }
        finally {
            this.checksumPathsLock.writeLock().unlock();
        }
    }

    public String generateCheckSum(String source) {
        StringBuilder checksum = new StringBuilder();
        try {
            byte[] checksumInBytes;
            byte[] compressedFileInBytes = source.getBytes(this.charset);
            MessageDigest md = MessageDigest.getInstance(this.digest);
            md.reset();
            for (byte b : checksumInBytes = md.digest(compressedFileInBytes)) {
                checksum.append(Integer.toHexString(0xFF & b));
            }
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)"Could not find MD5 algorithm for generating checksum", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"Unsupported encoding", (Throwable)e);
        }
        return checksum.toString();
    }

    public String getRelativePath(String sourcePath, String targetPath) {
        int lastForwardSlashIndex;
        StringBuilder sb = new StringBuilder();
        String pathPrefix = "";
        if (sourcePath != null && (lastForwardSlashIndex = sourcePath.lastIndexOf("/")) != -1) {
            pathPrefix = sourcePath.substring(0, lastForwardSlashIndex);
        }
        if (targetPath.startsWith("\"") || targetPath.startsWith("'")) {
            targetPath = targetPath.substring(1);
        }
        if (targetPath.endsWith("\"") || targetPath.endsWith("'")) {
            targetPath = targetPath.substring(0, targetPath.length() - 1);
        }
        if (targetPath.startsWith(".") && !targetPath.startsWith("..")) {
            targetPath = targetPath.substring(1);
        }
        while (targetPath.startsWith("../")) {
            int idx = pathPrefix.lastIndexOf("/");
            if (idx == -1) continue;
            pathPrefix = pathPrefix.substring(0, idx);
            targetPath = targetPath.substring(3);
        }
        sb.append(pathPrefix);
        if (!targetPath.startsWith("/")) {
            sb.append("/");
        }
        sb.append(targetPath);
        return sb.toString();
    }

    private ResourceInfoSentinel getResourceInfoSentinel() {
        if (RESOURCE_INFO_SENTINEL == null) {
            RESOURCE_INFO_SENTINEL = new ResourceInfoSentinel();
        }
        return RESOURCE_INFO_SENTINEL;
    }

    private class ResourceInfoSentinel
    extends ResourceInfo {
        private ResourceInfoSentinel() {
            super(null);
        }

        public InputStream loadInputStream() throws IOException {
            return null;
        }
    }

    private class ServletContextRes
    extends ResourceInfo {
        private ServletContextRes(String path) {
            super(path);
        }

        public InputStream loadInputStream() throws IOException {
            InputStream in = null;
            ServletContextResource resource = new ServletContextResource(DependencyHandler.this.servletContext, this.path);
            if (resource.exists()) {
                in = resource.getInputStream();
            }
            return in;
        }
    }

    private class ClassLoaderResource
    extends ResourceInfo {
        private ClassLoaderResource(String path) {
            super(path);
        }

        public InputStream loadInputStream() throws IOException {
            InputStream in = null;
            URL resourceUrl = ClassUtils.getDefaultClassLoader().getResource("META-INF/" + this.path);
            if (resourceUrl != null) {
                in = resourceUrl.openStream();
            }
            return in;
        }
    }

    private class ApplicationContextResource
    extends ResourceInfo {
        private ApplicationContextResource(String path) {
            super(path);
        }

        public InputStream loadInputStream() throws IOException {
            InputStream in = null;
            Resource r = DependencyHandler.this.applicationContext.getResource("classpath*:" + this.path);
            if (r != null && r.exists()) {
                in = r.getInputStream();
            }
            return in;
        }
    }

    protected abstract class ResourceInfo {
        protected String path;
        private String contents;

        protected ResourceInfo(String path) {
            this.path = path;
        }

        public String getContents() {
            return this.contents;
        }

        private void setContents(String contents) {
            this.contents = contents;
        }

        public InputStream getInputStream() throws IOException {
            InputStream in = null;
            in = this.contents == null ? this.loadInputStream() : new ByteArrayInputStream(this.contents.getBytes());
            return in;
        }

        public abstract InputStream loadInputStream() throws IOException;
    }
}

