/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.surf.DependencyAggregator;
import org.springframework.extensions.surf.DependencyHandler;
import org.springframework.extensions.surf.DojoDependencies;
import org.springframework.extensions.surf.DojoDependencyRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DojoDependencyHandler {
    private static final Log logger = LogFactory.getLog(DojoDependencyHandler.class);
    private DependencyHandler dependencyHandler = null;
    private DependencyAggregator dependencyAggregator = null;
    private WebFrameworkConfigElement webFrameworkConfigElement = null;
    private List<DojoDependencyRule> dependencyRules;
    private final ReadWriteLock depsLock = new ReentrantReadWriteLock();
    private final Map<String, DojoDependencies> cachedDeps = new HashMap<String, DojoDependencies>();
    private final ReadWriteLock cachedResourceLock = new ReentrantReadWriteLock();
    private Map<String, String> generatedResourceCache = new HashMap<String, String>();

    public void setDependencyHandler(DependencyHandler dependencyHandler) {
        this.dependencyHandler = dependencyHandler;
    }

    public void setDependencyAggregator(DependencyAggregator dependencyAggregator) {
        this.dependencyAggregator = dependencyAggregator;
    }

    public void setWebFrameworkConfigElement(WebFrameworkConfigElement webFrameworkConfigElement) {
        this.webFrameworkConfigElement = webFrameworkConfigElement;
    }

    public void setDependencyRules(List<DojoDependencyRule> dependencyRules) {
        this.dependencyRules = dependencyRules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DojoDependencies getCachedDeps(String path) {
        DojoDependencies deps = null;
        this.depsLock.readLock().lock();
        try {
            deps = this.cachedDeps.get(path);
        }
        finally {
            this.depsLock.readLock().unlock();
        }
        return deps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheDeps(String path, DojoDependencies deps) {
        this.depsLock.writeLock().lock();
        try {
            this.cachedDeps.put(path, deps);
        }
        finally {
            this.depsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCaches() {
        this.depsLock.writeLock().lock();
        try {
            this.cachedDeps.clear();
        }
        finally {
            this.depsLock.writeLock().unlock();
        }
        this.cachedResourceLock.writeLock().lock();
        try {
            this.generatedResourceCache.clear();
        }
        finally {
            this.cachedResourceLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DojoDependencies getDependencies(String path) {
        DojoDependencies deps = this.getCachedDeps(path);
        if (deps == null) {
            try {
                String compressedFile = this.dependencyAggregator.getCompressedFile(path, DependencyAggregator.CompressionType.JAVASCRIPT);
                if (compressedFile != null) {
                    deps = new DojoDependencies();
                    for (DojoDependencyRule rule : this.dependencyRules) {
                        rule.processRegexRules(path, compressedFile, deps);
                    }
                    this.cacheDeps(path, deps);
                }
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
        return deps;
    }

    public void recursivelyProcessDependencies(DojoDependencies deps, Map<String, DojoDependencies> allDeps) {
        if (deps != null) {
            for (String dep : deps.getJavaScriptDeps()) {
                if (allDeps.containsKey(dep)) continue;
                DojoDependencies requestedDeps = this.getCachedDeps(dep);
                if (requestedDeps == null) {
                    requestedDeps = this.getDependencies(dep);
                }
                allDeps.put(dep, requestedDeps);
                this.recursivelyProcessDependencies(requestedDeps, allDeps);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCachedResource(String path) {
        String resource = null;
        this.cachedResourceLock.readLock().lock();
        try {
            resource = this.generatedResourceCache.get(path);
        }
        finally {
            this.cachedResourceLock.readLock().unlock();
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheResource(String checksum, String resource) {
        this.cachedResourceLock.writeLock().lock();
        try {
            this.generatedResourceCache.put(checksum, resource);
        }
        finally {
            this.cachedResourceLock.writeLock().unlock();
        }
    }

    public String getChecksumPathForDependencies(String source) {
        String surfPackage = this.webFrameworkConfigElement.getDojoPackages().get("surf");
        String checksum = surfPackage + "/" + this.dependencyHandler.generateCheckSum(source) + ".js";
        this.cacheResource(checksum, source);
        return checksum;
    }

    protected String reverseAlias(String path) {
        for (Map.Entry<String, String> alias : this.webFrameworkConfigElement.getDojoPackages().entrySet()) {
            if (!path.startsWith(alias.getValue())) continue;
            path = alias.getKey() + path.substring(alias.getValue().length());
            break;
        }
        return path;
    }

    public String outputAggregateResource(Map<String, DojoDependencies> depsToOutput, String baseUrl) {
        StringBuilder sb = new StringBuilder();
        sb.append("//>>built\n");
        sb.append("require({cache:{\n");
        Iterator<Map.Entry<String, DojoDependencies>> i = depsToOutput.entrySet().iterator();
        while (i.hasNext()) {
            try {
                Map.Entry<String, DojoDependencies> currentDependency = i.next();
                String depName = currentDependency.getKey();
                String depPath = this.getPath(baseUrl, depName);
                depName = this.reverseAlias(depName);
                if (depName.endsWith(".js")) {
                    depName = depName.substring(0, depName.length() - 3);
                }
                StringBuilder tmp = new StringBuilder();
                tmp.append("'");
                tmp.append(depName);
                tmp.append("':function(){\n");
                tmp.append((CharSequence)this.outputDependency(depName, depPath, currentDependency.getValue()));
                tmp.append("}");
                if (i.hasNext()) {
                    tmp.append(",");
                }
                tmp.append("\n");
                sb.append((CharSequence)tmp);
            }
            catch (Exception e) {}
        }
        sb.append("}});");
        return sb.toString();
    }

    public StringBuilder outputDependency(String name, String path, DojoDependencies deps) throws IOException {
        StringBuilder currentDep = new StringBuilder();
        if (!deps.getTextDeps().isEmpty()) {
            currentDep.append("require({cache:{");
            Iterator<String> j = deps.getTextDeps().iterator();
            while (j.hasNext()) {
                String textDependency = j.next();
                currentDep.append("'url:");
                String textPath = this.getPath(path, textDependency);
                if (textPath.startsWith("/")) {
                    textPath = textPath.substring(1);
                }
                String shortTextPath = this.reverseAlias(textPath);
                currentDep.append(shortTextPath);
                currentDep.append("':");
                InputStream in = this.dependencyHandler.getResourceInputStream(textPath);
                if (in == null) continue;
                String textContents = this.dependencyHandler.convertResourceToString(in);
                textContents = textContents.replace("'", "\"").replace("\"", "\\\"").replace("\n", "").replace("\r", "");
                currentDep.append("'");
                currentDep.append(textContents);
                currentDep.append("'");
                if (j.hasNext()) {
                    currentDep.append(",");
                }
                currentDep.append("\n");
            }
            currentDep.append("}});");
        }
        InputStream in = this.dependencyHandler.getResourceInputStream(path);
        currentDep.append(this.dependencyHandler.convertResourceToString(in));
        return currentDep;
    }

    public String getPath(String sourcePath, String dependencyPath) {
        int idx;
        StringBuilder sb = new StringBuilder();
        if (dependencyPath.startsWith("\"") || dependencyPath.startsWith("'")) {
            dependencyPath = dependencyPath.substring(1);
        }
        if (dependencyPath.endsWith("\"") || dependencyPath.endsWith("'")) {
            dependencyPath = dependencyPath.substring(0, dependencyPath.length() - 1);
        }
        boolean usesModuleAlias = false;
        if (!(dependencyPath.startsWith(".") || dependencyPath.startsWith("..") || dependencyPath.startsWith("/") || (idx = dependencyPath.indexOf("/")) == -1)) {
            String firstFolder = dependencyPath.substring(0, idx);
            String alias = this.webFrameworkConfigElement.getDojoPackages().get(firstFolder);
            if (alias != null) {
                usesModuleAlias = true;
                String s = dependencyPath.replace(firstFolder, alias);
                sb.append(s);
            }
        }
        if (!usesModuleAlias) {
            sb.append(this.dependencyHandler.getRelativePath(sourcePath, dependencyPath));
        }
        return sb.toString();
    }
}

