/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf;

import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.extensions.surf.DependencyHandler;
import org.springframework.extensions.surf.DojoDependencies;
import org.springframework.extensions.surf.DojoDependencyHandler;

public class DojoDependencyRule {
    private String declarationRegex;
    private Pattern declarationRegexPattern;
    private String dependencyRegex;
    private Pattern dependencyRegexPattern;
    private int targetGroup;
    private DojoDependencyHandler dojoDependencyHandler;
    private DependencyHandler dependencyHandler;

    protected void processRegexRules(String filePath, String fileContents, DojoDependencies dependencies) {
        Matcher m1 = this.declarationRegexPattern.matcher(fileContents);
        while (m1.find()) {
            String deps;
            if (m1.groupCount() < this.targetGroup || (deps = m1.group(this.targetGroup)) == null) continue;
            Matcher m2 = this.dependencyRegexPattern.matcher(deps);
            while (m2.find()) {
                String dep = m2.group(1);
                if (dep == null) continue;
                this.processDependency(dep, filePath, fileContents, m2, dependencies);
            }
        }
    }

    protected void processDependency(String dependency, String sourcePath, String sourceContents, Matcher matcher, DojoDependencies dependencies) {
        if ((dependency = dependency.trim()).startsWith("\"") || dependency.startsWith("'")) {
            dependency = dependency.substring(1);
        }
        if (dependency.endsWith("\"") || dependency.startsWith("'")) {
            dependency = dependency.substring(0, dependency.length() - 1);
        }
        if (dependency.contains("!")) {
            int eIdx;
            if (dependency.startsWith("dojo/text!")) {
                String textDependency = dependency.substring(10);
                dependencies.addTextDep(textDependency);
            }
            String pluginDep = dependency.substring(0, dependency.indexOf("!"));
            String pluginPath = this.dojoDependencyHandler.getPath(sourcePath, pluginDep) + ".js";
            this.addJavaScriptDependency(dependencies, pluginPath);
            if (pluginPath.endsWith("dojo/has.js") && (eIdx = dependency.indexOf("!")) != -1) {
                String ternary = dependency.substring(eIdx + 1);
                Pattern p1 = Pattern.compile("([^:|\\?])*");
                Matcher m1 = p1.matcher(ternary);
                while (m1.find()) {
                    String ternaryDep = m1.group(0);
                    if (ternaryDep == null || ternaryDep.equals("")) continue;
                    String ternaryDepPath = this.dojoDependencyHandler.getPath(sourcePath, ternaryDep) + ".js";
                    this.addJavaScriptDependency(dependencies, ternaryDepPath);
                }
            }
        } else {
            String depPath = this.dojoDependencyHandler.getPath(sourcePath, dependency) + ".js";
            this.addJavaScriptDependency(dependencies, depPath);
        }
    }

    protected void addJavaScriptDependency(DojoDependencies dependencies, String path) {
        try {
            InputStream in = this.dependencyHandler.getResourceInputStream(path);
            if (in != null) {
                dependencies.addJavaScriptDep(path);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getDeclarationRegex() {
        return this.declarationRegex;
    }

    public Pattern getDeclarationRegexPattern() {
        return this.declarationRegexPattern;
    }

    public void setDeclarationRegex(String declarationRegex) {
        this.declarationRegex = declarationRegex;
        this.declarationRegexPattern = Pattern.compile(declarationRegex);
    }

    public String getDependencyRegex() {
        return this.dependencyRegex;
    }

    public Pattern getDependencyRegexPattern() {
        return this.dependencyRegexPattern;
    }

    public void setDependencyRegex(String dependencyRegex) {
        this.dependencyRegex = dependencyRegex;
        this.dependencyRegexPattern = Pattern.compile(dependencyRegex);
    }

    public int getTargetGroup() {
        return this.targetGroup;
    }

    public void setTargetGroup(int targetGroup) {
        this.targetGroup = targetGroup;
    }

    public void setDojoDependencyHandler(DojoDependencyHandler dojoDependencyHandler) {
        this.dojoDependencyHandler = dojoDependencyHandler;
    }

    public DojoDependencyHandler getDojoDependencyHandler() {
        return this.dojoDependencyHandler;
    }

    public void setDependencyHandler(DependencyHandler dependencyHandler) {
        this.dependencyHandler = dependencyHandler;
    }

    public DependencyHandler getDependencyHandler() {
        return this.dependencyHandler;
    }
}

