/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public class ServletUtil {
    public static final String VIEW_REQUEST_ATTRIBUTE_NAME = "surfViewHttpServletRequest";
    private static final Log logger = LogFactory.getLog(ServletUtil.class);
    public static final String IE_USER_AGENT_HEADER_LOWER_CASE = "msie";
    public static final String USER_AGENT = "User-Agent";
    public static final String SEMI_COLON = ";";

    public static final Float getInternetExplorerVersion(HttpServletRequest request) {
        Float version;
        block6: {
            int ieIndex;
            version = null;
            String userAgentHeader = request.getHeader(USER_AGENT);
            if (userAgentHeader != null && (ieIndex = userAgentHeader.toLowerCase().indexOf(IE_USER_AGENT_HEADER_LOWER_CASE)) != -1) {
                int closingSemiColonIndex = userAgentHeader.indexOf(SEMI_COLON, ieIndex + IE_USER_AGENT_HEADER_LOWER_CASE.length());
                if (closingSemiColonIndex == -1) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Could not find closing \";\" for Internet Explorer data in User-Agent header: " + userAgentHeader));
                    }
                } else {
                    String ieString = userAgentHeader.substring(ieIndex + IE_USER_AGENT_HEADER_LOWER_CASE.length(), closingSemiColonIndex).trim();
                    try {
                        version = Float.valueOf(Float.parseFloat(ieString));
                    }
                    catch (NumberFormatException e) {
                        if (!logger.isDebugEnabled()) break block6;
                        logger.debug((Object)("Could not parse Internet Explorer version from User-Agent header: " + userAgentHeader));
                    }
                }
            }
        }
        return version;
    }

    public static void setRequest(HttpServletRequest request) {
        RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
        if (attributes != null) {
            attributes.setAttribute(VIEW_REQUEST_ATTRIBUTE_NAME, (Object)request, 0);
        }
    }

    public static HttpServletRequest getRequest() {
        Object tmp;
        HttpServletRequest request = null;
        RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
        if (attributes != null && (tmp = attributes.getAttribute(VIEW_REQUEST_ATTRIBUTE_NAME, 0)) instanceof HttpServletRequest) {
            request = (HttpServletRequest)tmp;
        }
        return request;
    }

    public static HttpSession getSession() {
        return ServletUtil.getSession(true);
    }

    public static HttpSession getSession(boolean create) {
        HttpSession session = null;
        HttpServletRequest request = ServletUtil.getRequest();
        if (request != null) {
            session = request.getSession(create);
        }
        return session;
    }
}

