/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.mvc;

import java.io.IOException;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.FrameworkBean;
import org.springframework.extensions.surf.ThreadLocalPreviewContext;
import org.springframework.extensions.surf.mvc.AbstractWebFrameworkController;
import org.springframework.web.servlet.ModelAndView;

public class PreviewController
extends AbstractWebFrameworkController {
    private static Log logger = LogFactory.getLog(PreviewController.class);
    private FrameworkBean frameworkUtil;

    public Log getLogger() {
        return logger;
    }

    public void setFrameworkUtil(FrameworkBean frameworkUtil) {
        this.frameworkUtil = frameworkUtil;
    }

    public ModelAndView createModelAndView(HttpServletRequest request, HttpServletResponse response) {
        if (this.getWebFrameworkConfiguration().isPreviewEnabled()) {
            String _webappId;
            String _storeId;
            boolean updated = false;
            String storeId = null;
            String webappId = null;
            String uri = request.getRequestURI();
            uri = uri.substring(request.getContextPath().length());
            StringTokenizer t = new StringTokenizer(uri, "/");
            String servletName = t.nextToken();
            if (t.hasMoreTokens()) {
                storeId = t.nextToken();
            }
            if (t.hasMoreTokens()) {
                webappId = t.nextToken();
            }
            if ((_storeId = request.getParameter("alfStoreId")) == null) {
                _storeId = request.getParameter("s");
            }
            if (_storeId != null) {
                storeId = _storeId;
            }
            if ((_webappId = request.getParameter("alfWebappId")) == null) {
                _webappId = request.getParameter("w");
            }
            if (_webappId != null) {
                webappId = _webappId;
            }
            if (storeId != null) {
                updated = true;
                request.getSession(true).setAttribute("alfStoreId", (Object)storeId);
            }
            if (storeId != null && webappId != null) {
                updated = true;
                request.getSession(true).setAttribute("alfWebappId", (Object)webappId);
            }
            if (updated) {
                ThreadLocalPreviewContext sandboxContext = new ThreadLocalPreviewContext(storeId, webappId);
                this.frameworkUtil.resetWebScripts();
            }
            try {
                response.sendRedirect(request.getContextPath());
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return null;
    }
}

