/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.mvc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.surf.DependencyAggregator;
import org.springframework.extensions.surf.DependencyHandler;
import org.springframework.extensions.surf.DependencyResource;
import org.springframework.extensions.surf.DojoDependencyHandler;
import org.springframework.extensions.surf.ServletUtil;
import org.springframework.extensions.surf.mvc.VirtualizedResourceController;

public class ResourceController
extends VirtualizedResourceController {
    public static final String HTTP_HEADER_EXPIRES = "Expires";
    public static final String HTTP_HEADER_FAR_FUTURE_EXPIRES_VALUE = "Sun, 17-Jan-2038 19:14:07 GMT";
    private DependencyHandler dependencyHandler;
    private DependencyAggregator dependencyAggregator;
    private DojoDependencyHandler dojoDependencyHandler;
    private WebFrameworkConfigElement webframeworkConfigElement;
    public static final String FORWARD_SLASH = "/";
    public static final String FULL_STOP = ".";
    public static final String DOUBLE_FULL_STOP = "..";
    public static final String DOUBLE_QUOTES = "\"";
    public static final String SINGLE_QUOTE = "'";

    public void setDependencyHandler(DependencyHandler dependencyHandler) {
        this.dependencyHandler = dependencyHandler;
    }

    public void setDependencyAggregator(DependencyAggregator dependencyAggregator) {
        this.dependencyAggregator = dependencyAggregator;
    }

    public void setDojoDependencyHandler(DojoDependencyHandler dojoDependencyHandler) {
        this.dojoDependencyHandler = dojoDependencyHandler;
    }

    public void setWebframeworkConfigElement(WebFrameworkConfigElement webframeworkConfigElement) {
        this.webframeworkConfigElement = webframeworkConfigElement;
    }

    public boolean dispatchResource(String path, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String aggregatedDojoResource;
        DependencyResource resource;
        boolean resolved = false;
        if (this.webframeworkConfigElement.isPreviewEnabled()) {
            String endpointId = request.getParameter("e");
            String storeId = request.getParameter("s");
            String webappId = request.getParameter("w");
            resolved = this.retrieveRemoteResource(request, response, path, endpointId, storeId, webappId);
        }
        if ((resource = this.dependencyAggregator.getCachedDependencyResource(path)) != null) {
            byte[] bytes = resource.getContent().getBytes();
            this.applyHeaders(path, response, bytes.length, 0L);
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            this.copyStream(in, (OutputStream)response.getOutputStream());
            resolved = true;
        }
        if (this.webframeworkConfigElement.isDojoEnabled() && (aggregatedDojoResource = this.dojoDependencyHandler.getCachedResource(path)) != null) {
            byte[] bytes = aggregatedDojoResource.getBytes();
            this.applyHeaders(path, response, bytes.length, 0L);
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            this.copyStream(in, (OutputStream)response.getOutputStream());
            resolved = true;
        }
        if (!resolved) {
            InputStream in = null;
            Float ieVersion = ServletUtil.getInternetExplorerVersion(request);
            in = ieVersion != null && ieVersion.floatValue() < 8.0f ? this.dependencyHandler.getUnmodifiedResourceInputStream(path) : this.dependencyHandler.getResourceInputStream(path);
            if (in != null) {
                this.applyHeaders(path, response, in.available(), 0L);
                this.copyStream(in, (OutputStream)response.getOutputStream());
                resolved = true;
            }
        }
        if (!resolved) {
            resolved = super.dispatchResource(path, request, response);
        }
        return resolved;
    }

    public String getPath(String sourcePath, String dependencyPath) {
        String pathPrefix = sourcePath.substring(0, sourcePath.lastIndexOf(FORWARD_SLASH));
        if (dependencyPath.startsWith(DOUBLE_QUOTES) || dependencyPath.startsWith(SINGLE_QUOTE)) {
            dependencyPath = dependencyPath.substring(1);
        }
        if (dependencyPath.endsWith(DOUBLE_QUOTES) || dependencyPath.endsWith(SINGLE_QUOTE)) {
            dependencyPath = dependencyPath.substring(0, dependencyPath.length() - 1);
        }
        if (dependencyPath.startsWith(FULL_STOP) && !dependencyPath.startsWith(DOUBLE_FULL_STOP)) {
            dependencyPath = dependencyPath.substring(1);
        }
        StringBuilder sb = new StringBuilder(pathPrefix);
        if (!dependencyPath.startsWith(FORWARD_SLASH)) {
            sb.append(FORWARD_SLASH);
        }
        sb.append(dependencyPath);
        return sb.toString();
    }
}

