/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.mvc;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.RemoteConfigElement;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.WebFrameworkServiceRegistry;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.surf.util.WrappedHttpServletRequest;
import org.springframework.extensions.surf.util.WrappedHttpServletResponse;
import org.springframework.extensions.webscripts.servlet.mvc.ResourceController;

public class VirtualizedResourceController
extends ResourceController {
    private static Log logger = LogFactory.getLog(VirtualizedResourceController.class);
    private WebFrameworkServiceRegistry webFrameworkServiceRegistry;
    private RemoteConfigElement remoteConfig;

    public void setServiceRegistry(WebFrameworkServiceRegistry webFrameworkServiceRegistry) {
        this.webFrameworkServiceRegistry = webFrameworkServiceRegistry;
    }

    public WebFrameworkServiceRegistry getServiceRegistry() {
        return this.webFrameworkServiceRegistry;
    }

    public void setRemoteConfig(RemoteConfigElement remoteConfig) {
        this.remoteConfig = remoteConfig;
    }

    public Log getLogger() {
        return logger;
    }

    public boolean dispatchResource(String path, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean previewMode = this.getServiceRegistry().getWebFrameworkConfiguration().isPreviewEnabled();
        boolean resolved = false;
        if (!resolved && previewMode) {
            String endpointId = request.getParameter("e");
            String storeId = request.getParameter("s");
            String webappId = request.getParameter("w");
            resolved = this.retrieveRemoteResource(request, response, path, endpointId, storeId, webappId);
        }
        if (!resolved) {
            resolved = super.dispatchResource(path, request, response);
        }
        return resolved;
    }

    public boolean retrieveRemoteResource(HttpServletRequest request, HttpServletResponse response, String path, String endpointId, String storeId, String webappId) throws ServletException, IOException {
        boolean exists;
        boolean resolved = false;
        RequestContext context = ThreadLocalRequestContext.getRequestContext();
        if (endpointId == null) {
            endpointId = this.remoteConfig.getDefaultEndpointId();
        }
        if (storeId != null) {
            storeId = context.getServiceRegistry().getObjectPersistenceService().getPersistenceContext().getStoreId();
        }
        if (webappId == null) {
            webappId = context.getServiceRegistry().getObjectPersistenceService().getPersistenceContext().getWebappId();
        }
        if (exists = this.checkRemoteResourceExists(context, request, response, path, endpointId, storeId, webappId)) {
            StringBuilder fb = new StringBuilder(128);
            fb.append(request.getServletPath());
            fb.append("/endpoint/");
            fb.append(endpointId);
            fb.append("/avmstore/get/s/");
            fb.append(storeId);
            fb.append("/w/");
            fb.append(webappId);
            if (!path.startsWith("/")) {
                fb.append("/");
            }
            fb.append(path);
            String newUri = fb.toString();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Formed virtual retrieval path: " + newUri));
            }
            if (request instanceof WrappedHttpServletRequest) {
                ((WrappedHttpServletRequest)request).setRequestURI(request.getContextPath() + newUri);
            }
            RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(newUri);
            dispatcher.include((ServletRequest)request, (ServletResponse)response);
            resolved = true;
        }
        return resolved;
    }

    public boolean checkRemoteResourceExists(RequestContext context, HttpServletRequest request, HttpServletResponse response, String path, String endpointId, String storeId, String webappId) throws ServletException, IOException {
        boolean exists = false;
        if (endpointId == null) {
            endpointId = this.remoteConfig.getDefaultEndpointId();
        }
        if (storeId != null) {
            storeId = context.getServiceRegistry().getObjectPersistenceService().getPersistenceContext().getStoreId();
        }
        if (webappId == null) {
            webappId = context.getServiceRegistry().getObjectPersistenceService().getPersistenceContext().getWebappId();
        }
        StringBuilder fb = new StringBuilder(128);
        fb.append(request.getServletPath());
        fb.append("/endpoint/");
        fb.append(endpointId);
        fb.append("/avmstore/has/s/");
        fb.append(storeId);
        fb.append("/w/");
        fb.append(webappId);
        if (!path.startsWith("/")) {
            fb.append("/");
        }
        fb.append(path);
        String newUri = fb.toString();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Formed virtual retrieval path: " + newUri));
        }
        WrappedHttpServletRequest wrappedRequest = new WrappedHttpServletRequest(request);
        WrappedHttpServletResponse wrappedResponse = new WrappedHttpServletResponse(response);
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(newUri);
        dispatcher.include((ServletRequest)wrappedRequest, (ServletResponse)wrappedResponse);
        String result = wrappedResponse.getOutput();
        if ("true".equalsIgnoreCase(result)) {
            exists = true;
        }
        return exists;
    }
}

