/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.render;

import java.util.HashMap;
import java.util.Map;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.render.RenderMode;
import org.springframework.extensions.surf.render.Renderable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProcessorContext {
    private final RequestContext context;
    private final Map<RenderMode, ProcessorDescriptor> descriptors = new HashMap<RenderMode, ProcessorDescriptor>(4, 1.0f);

    public ProcessorContext(RequestContext context) {
        this.context = context;
    }

    public RequestContext getRequestContext() {
        return this.context;
    }

    public ProcessorDescriptor getDescriptor(RenderMode renderMode) {
        ProcessorDescriptor processorDescriptor = this.descriptors.get((Object)renderMode);
        return processorDescriptor;
    }

    public void putDescriptor(RenderMode renderMode, ProcessorDescriptor descriptor) {
        this.descriptors.put(renderMode, descriptor);
    }

    public void removeDescriptor(RenderMode renderMode) {
        this.descriptors.remove((Object)renderMode);
    }

    public void addDescriptor(RenderMode renderMode, Map<String, String> properties) {
        ProcessorDescriptor descriptor = new ProcessorDescriptor(properties);
        this.putDescriptor(renderMode, descriptor);
    }

    public void load(Renderable renderable) {
        RenderMode[] renderModes = renderable.getRenderModes();
        for (int i = 0; i < renderModes.length; ++i) {
            Map<String, String> properties = renderable.getProcessorProperties(renderModes[i]);
            ProcessorDescriptor descriptor = new ProcessorDescriptor(properties);
            this.putDescriptor(renderModes[i], descriptor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ProcessorDescriptor {
        public final Map<String, String> properties;

        public ProcessorDescriptor() {
            this.properties = new HashMap<String, String>(4, 1.0f);
        }

        public ProcessorDescriptor(Map<String, String> properties) {
            this.properties = properties;
        }

        public void put(String key, String value) {
            this.properties.put(key, value);
        }

        public String get(String key) {
            return this.properties.get(key);
        }

        public void remove(String key) {
            this.properties.remove(key);
        }

        public Map<String, String> map() {
            return this.properties;
        }
    }
}

