/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.render.bean;

import java.awt.image.renderable.RenderContext;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.ModelObjectService;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.exception.PageRendererExecutionException;
import org.springframework.extensions.surf.exception.RendererExecutionException;
import org.springframework.extensions.surf.render.AbstractRenderer;
import org.springframework.extensions.surf.render.RenderFocus;
import org.springframework.extensions.surf.render.bean.TemplateInstanceRenderer;
import org.springframework.extensions.surf.types.Page;
import org.springframework.extensions.surf.types.TemplateInstance;

public class PageRenderer
extends AbstractRenderer {
    private TemplateInstanceRenderer templateRenderer;
    private ModelObjectService modelObjectService;

    public void setTemplateRenderer(TemplateInstanceRenderer templateRenderer) {
        this.templateRenderer = templateRenderer;
    }

    public void setModelObjectService(ModelObjectService modelObjectService) {
        this.modelObjectService = modelObjectService;
    }

    public void body(RequestContext context, ModelObject object) throws RendererExecutionException {
        Page page = null;
        if (object == null || !(object instanceof Page)) {
            throw new PageRendererExecutionException("Unable to render page: null");
        }
        page = (Page)object;
        String templateId = page.getTemplateId();
        TemplateInstance template = this.modelObjectService.getTemplate(templateId);
        if (template == null) {
            throw new PageRendererExecutionException("Unable to locate template for page: " + page.getId());
        }
        this.templateRenderer.render(context, template, RenderFocus.BODY);
    }

    public void header(RenderContext context) throws RendererExecutionException {
    }
}

