/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.resource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.cache.BasicCache;
import org.springframework.extensions.surf.resource.AbstractResourceLoaderFactory;
import org.springframework.extensions.surf.resource.ResourceLoader;

public abstract class AbstractCachingResourceLoaderFactory
extends AbstractResourceLoaderFactory {
    private static final Log logger = LogFactory.getLog(AbstractCachingResourceLoaderFactory.class);
    private BasicCache<ResourceLoader> cache = null;
    private long cacheTimeout = 300000L;

    public void setCacheTimeout(long cacheTimeout) {
        this.cacheTimeout = cacheTimeout;
    }

    public synchronized ResourceLoader getResourceLoader(String protocolId, String endpointId) {
        String cacheKey;
        ResourceLoader resourceLoader;
        if (this.cache == null) {
            this.cache = new BasicCache(this.cacheTimeout);
        }
        if ((resourceLoader = this.cache.get(cacheKey = this.getCacheKey(protocolId, endpointId))) == null) {
            resourceLoader = this.buildResourceLoader(protocolId, endpointId);
            this.cache.put(cacheKey, resourceLoader);
        }
        return resourceLoader;
    }

    private String getCacheKey(String protocolId, String endpointId) {
        StringBuilder key = new StringBuilder();
        key.append(protocolId != null ? protocolId : "null");
        key.append("_");
        key.append(endpointId != null ? endpointId : "null");
        return key.toString();
    }

    public abstract ResourceLoader buildResourceLoader(String var1, String var2);
}

