/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.types;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.springframework.extensions.surf.FrameworkBean;
import org.springframework.extensions.surf.ModelHelper;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.ModelPersisterInfo;
import org.springframework.extensions.surf.resource.ModelObjectResourceProvider;
import org.springframework.extensions.surf.resource.Resource;
import org.springframework.extensions.surf.resource.ResourceProvider;
import org.springframework.extensions.surf.util.XMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModelObject
implements ModelObject,
ResourceProvider {
    private static final String VERSION_UNKNOWN = "unknown";
    private static final String CONTAINER_PROPERTIES = "properties";
    private static final String CONTAINER_RESOURCES = "resources";
    private String documentXML;
    protected final ModelPersisterInfo info;
    protected String id;
    protected long modificationTime;
    protected Map<String, Serializable> modelProperties;
    protected Map<String, Serializable> customProperties;
    protected String title;
    protected String titleId;
    protected String description;
    protected String descriptionId;
    protected ResourceProvider resourceContainer = null;
    private ReadWriteLock propertyLock = new ReentrantReadWriteLock();

    public AbstractModelObject(String id, ModelPersisterInfo info, Document document) {
        this.info = info;
        this.updateXML(document);
        this.id = id;
    }

    protected AbstractModelObject() {
        this.info = null;
        this.documentXML = null;
        this.id = null;
    }

    protected void updateXML(Document document) {
        this.documentXML = XMLUtil.toXML(document);
    }

    @Override
    public final ModelPersisterInfo getKey() {
        return this.info;
    }

    @Override
    public final String getId() {
        return this.id;
    }

    @Override
    public final String getTitle() {
        if (this.title == null) {
            this.title = this.getProperty("title");
        }
        return this.title;
    }

    @Override
    public final String getTitleId() {
        if (this.titleId == null) {
            this.titleId = this.getProperty("title-id");
        }
        return this.titleId;
    }

    @Override
    public final void setTitle(String title) {
        this.setProperty("title", title);
        this.title = title;
    }

    @Override
    public final void setTitleId(String titleId) {
        this.setProperty("title-id", titleId);
        this.titleId = titleId;
    }

    @Override
    public final String getDescription() {
        if (this.description == null) {
            this.description = this.getProperty("description");
        }
        return this.description;
    }

    @Override
    public final String getDescriptionId() {
        if (this.descriptionId == null) {
            this.descriptionId = this.getProperty("description-id");
        }
        return this.descriptionId;
    }

    @Override
    public final void setDescription(String value) {
        this.setProperty("description", value);
        this.description = value;
    }

    @Override
    public final void setDescriptionId(String value) {
        this.setProperty("description-id", value);
        this.descriptionId = value;
    }

    @Override
    public final boolean isSaved() {
        return this.info.isSaved();
    }

    @Override
    public final Document getDocument() {
        try {
            return XMLUtil.parse(this.documentXML);
        }
        catch (DocumentException err) {
            throw new IllegalStateException("Unable to parse ModelObject XML content: " + this.documentXML);
        }
    }

    @Override
    public final String toXML() {
        return this.documentXML;
    }

    @Override
    public final boolean getBooleanProperty(String propertyName) {
        String val = this.getProperty(propertyName);
        return Boolean.parseBoolean(val);
    }

    @Override
    public final String getProperty(String propertyName) {
        if (this.isModelProperty(propertyName)) {
            return this.getModelProperty(propertyName);
        }
        return this.getCustomProperty(propertyName);
    }

    @Override
    public final void setProperty(String propertyName, String propertyValue) {
        if (this.isModelProperty(propertyName)) {
            this.setModelProperty(propertyName, propertyValue);
        } else {
            this.setCustomProperty(propertyName, propertyValue);
        }
    }

    @Override
    public final void removeProperty(String propertyName) {
        if (this.isModelProperty(propertyName)) {
            this.removeModelProperty(propertyName);
        } else {
            this.removeCustomProperty(propertyName);
        }
    }

    protected final boolean isCustomProperty(String propertyName) {
        return !this.isModelProperty(propertyName);
    }

    protected final boolean isModelProperty(String propertyName) {
        return ModelHelper.isModelProperty(this, propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String getModelProperty(String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException("Property Name is mandatory.");
        }
        Map<String, Serializable> properties = this.getModelProperties();
        this.propertyLock.readLock().lock();
        try {
            String string = (String)((Object)properties.get(propertyName));
            return string;
        }
        finally {
            this.propertyLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setModelProperty(String propertyName, String propertyValue) {
        if (propertyName == null) {
            throw new IllegalArgumentException("Property Name is mandatory.");
        }
        if (propertyValue == null) {
            this.removeModelProperty(propertyName);
            return;
        }
        Map<String, Serializable> properties = this.getModelProperties();
        this.propertyLock.writeLock().lock();
        try {
            Document document = this.getDocument();
            Element el = document.getRootElement().element(propertyName);
            if (el == null) {
                el = document.getRootElement().addElement(propertyName);
            }
            el.setText(propertyValue);
            properties.put(propertyName, (Serializable)((Object)propertyValue));
            this.updateXML(document);
        }
        finally {
            this.propertyLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeModelProperty(String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException("Property Name is mandatory.");
        }
        Map<String, Serializable> properties = this.getModelProperties();
        this.propertyLock.writeLock().lock();
        try {
            Document document = this.getDocument();
            Element el = document.getRootElement().element(propertyName);
            if (el != null) {
                document.getRootElement().remove(el);
                properties.remove(propertyName);
                this.updateXML(document);
            }
        }
        finally {
            this.propertyLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String getCustomProperty(String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException("Property Name is mandatory.");
        }
        Map<String, Serializable> properties = this.getCustomProperties();
        this.propertyLock.readLock().lock();
        try {
            String string = (String)((Object)properties.get(propertyName));
            return string;
        }
        finally {
            this.propertyLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setCustomProperty(String propertyName, String propertyValue) {
        if (propertyName == null) {
            throw new IllegalArgumentException("Property Name is mandatory.");
        }
        if (propertyValue == null) {
            this.removeCustomProperty(propertyName);
            return;
        }
        Map<String, Serializable> props = this.getCustomProperties();
        this.propertyLock.writeLock().lock();
        try {
            Element el;
            Document document = this.getDocument();
            Element properties = document.getRootElement().element(CONTAINER_PROPERTIES);
            if (properties == null) {
                properties = document.getRootElement().addElement(CONTAINER_PROPERTIES);
            }
            if ((el = properties.element(propertyName)) == null) {
                el = properties.addElement(propertyName);
            }
            el.setText(propertyValue);
            props.put(propertyName, (Serializable)((Object)propertyValue));
            this.updateXML(document);
        }
        finally {
            this.propertyLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeCustomProperty(String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException("Property Name is mandatory.");
        }
        Map<String, Serializable> props = this.getCustomProperties();
        this.propertyLock.writeLock().lock();
        try {
            Element el;
            Document document = this.getDocument();
            Element properties = document.getRootElement().element(CONTAINER_PROPERTIES);
            if (properties != null && (el = properties.element(propertyName)) != null) {
                properties.remove(el);
                props.remove(propertyName);
                this.updateXML(document);
            }
        }
        finally {
            this.propertyLock.writeLock().unlock();
        }
    }

    @Override
    public final Map<String, Serializable> getProperties() {
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>(16, 1.0f);
        properties.putAll(this.getModelProperties());
        properties.putAll(this.getCustomProperties());
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Map<String, Serializable> getModelProperties() {
        block8: {
            this.propertyLock.readLock().lock();
            try {
                if (this.modelProperties != null) break block8;
                this.propertyLock.readLock().unlock();
                this.propertyLock.writeLock().lock();
                try {
                    if (this.modelProperties == null) {
                        HashMap<String, Serializable> modelProperties = new HashMap<String, Serializable>(8, 1.0f);
                        List elements = this.getDocument().getRootElement().elements();
                        for (int i = 0; i < elements.size(); ++i) {
                            Element el = (Element)elements.get(i);
                            String elementName = el.getName();
                            if (elementName == null || CONTAINER_PROPERTIES.equals(elementName) || CONTAINER_RESOURCES.equals(elementName)) continue;
                            String elementValue = el.getStringValue();
                            modelProperties.put(elementName, (Serializable)((Object)elementValue));
                        }
                        this.modelProperties = modelProperties;
                    }
                }
                finally {
                    this.propertyLock.readLock().lock();
                    this.propertyLock.writeLock().unlock();
                }
            }
            finally {
                this.propertyLock.readLock().unlock();
            }
        }
        return this.modelProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Serializable> getCustomProperties() {
        block9: {
            this.propertyLock.readLock().lock();
            try {
                if (this.customProperties != null) break block9;
                this.propertyLock.readLock().unlock();
                this.propertyLock.writeLock().lock();
                try {
                    if (this.customProperties == null) {
                        HashMap<String, Serializable> customProperties = new HashMap<String, Serializable>(4, 1.0f);
                        Element properties = this.getDocument().getRootElement().element(CONTAINER_PROPERTIES);
                        if (properties != null) {
                            List elements = properties.elements();
                            for (int i = 0; i < elements.size(); ++i) {
                                Element el = (Element)elements.get(i);
                                customProperties.put(el.getName(), (Serializable)((Object)el.getTextTrim()));
                            }
                        }
                        this.customProperties = customProperties;
                    }
                }
                finally {
                    this.propertyLock.readLock().lock();
                    this.propertyLock.writeLock().unlock();
                }
            }
            finally {
                this.propertyLock.readLock().unlock();
            }
        }
        return this.customProperties;
    }

    @Override
    public final long getModificationTime() {
        return this.modificationTime;
    }

    public final void setModificationTime(long modificationTime) {
        this.modificationTime = modificationTime;
    }

    @Override
    public final void touch() {
        this.setModificationTime(System.currentTimeMillis());
    }

    @Override
    public abstract String getTypeId();

    public String toString() {
        return this.getTypeId() + ": " + this.getId() + ", " + this.toXML();
    }

    @Override
    public final String getPersisterId() {
        return this.info.getPersisterId();
    }

    @Override
    public final String getStoragePath() {
        return this.info.getStoragePath();
    }

    @Override
    public Resource getResource(String name) {
        return this.getResourceContainer().getResource(name);
    }

    @Override
    public Resource[] getResources() {
        return this.getResourceContainer().getResources();
    }

    @Override
    public Map<String, Resource> getResourcesMap() {
        return this.getResourceContainer().getResourcesMap();
    }

    @Override
    public Resource addResource(String name, String resourceId) {
        String[] ids = FrameworkBean.getResourceService().getResourceDescriptorIds(resourceId);
        return this.getResourceContainer().addResource(name, ids[0], ids[1], ids[2]);
    }

    @Override
    public Resource addResource(String name, String protocolId, String endpointId, String objectId) {
        return this.getResourceContainer().addResource(name, protocolId, endpointId, objectId);
    }

    @Override
    public void updateResource(String name, Resource resource) {
        this.getResourceContainer().updateResource(name, resource);
    }

    @Override
    public void removeResource(String name) {
        this.getResourceContainer().removeResource(name);
    }

    protected synchronized ResourceProvider getResourceContainer() {
        if (this.resourceContainer == null) {
            this.resourceContainer = new ModelObjectResourceProvider(this);
        }
        return this.resourceContainer;
    }

    public void setId(String id) {
        this.id = id;
    }
}

