/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import freemarker.ext.jsp.TaglibFactory;
import freemarker.ext.servlet.HttpRequestHashModel;
import freemarker.ext.servlet.HttpRequestParametersHashModel;
import freemarker.ext.servlet.HttpSessionHashModel;
import freemarker.ext.servlet.ServletContextHashModel;
import freemarker.template.ObjectWrapper;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.mozilla.javascript.Scriptable;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.directives.AnchorFreeMarkerDirective;
import org.springframework.extensions.directives.ChromeIncludeFreeMarkerDirective;
import org.springframework.extensions.directives.ComponentFreemarkerTagDirective;
import org.springframework.extensions.directives.DirectiveFactory;
import org.springframework.extensions.directives.LinkFreeMarkerDirective;
import org.springframework.extensions.directives.MessagesDependencyDirective;
import org.springframework.extensions.directives.RegionFreemarkerTagDirective;
import org.springframework.extensions.directives.ResourceFreemarkerTagDirective;
import org.springframework.extensions.directives.StyleSheetFreeMarkerDirective;
import org.springframework.extensions.directives.SurfBugIncludeFreeMarkerDirective;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.ServletUtil;
import org.springframework.extensions.surf.exception.RendererExecutionException;
import org.springframework.extensions.surf.extensibility.ExtensibilityModel;
import org.springframework.extensions.surf.extensibility.impl.MarkupDirective;
import org.springframework.extensions.surf.render.RenderService;
import org.springframework.extensions.surf.types.Chrome;
import org.springframework.extensions.surf.types.Component;
import org.springframework.extensions.surf.types.SubComponent;
import org.springframework.extensions.surf.types.SurfBug;
import org.springframework.extensions.surf.types.TemplateInstance;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.extensions.webscripts.FreemarkerI18NMessageMethod;
import org.springframework.extensions.webscripts.FreemarkerResourceUrlMethod;
import org.springframework.extensions.webscripts.ScriptConfigModel;
import org.springframework.extensions.webscripts.ScriptForm;
import org.springframework.extensions.webscripts.ScriptFormData;
import org.springframework.extensions.webscripts.ScriptRenderContext;
import org.springframework.extensions.webscripts.ScriptRenderingInstance;
import org.springframework.extensions.webscripts.ScriptResource;
import org.springframework.extensions.webscripts.ScriptSiteData;
import org.springframework.extensions.webscripts.ScriptSurf;
import org.springframework.extensions.webscripts.ScriptUser;
import org.springframework.extensions.webscripts.ScriptValueConverter;
import org.springframework.extensions.webscripts.ScriptWebApplication;
import org.springframework.extensions.webscripts.ScriptWidgetUtils;
import org.springframework.extensions.webscripts.TemplateConfigModel;
import org.springframework.extensions.webscripts.URLHelper;
import org.springframework.extensions.webscripts.WebScript;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProcessorModelHelper
implements ApplicationContextAware {
    public static final String MODEL_CONFIG = "config";
    public static final String MODEL_HEAD = "head";
    public static final String MODEL_URL = "url";
    public static final String MODEL_USER = "user";
    public static final String MODEL_INSTANCE = "instance";
    public static final String MODEL_CONTENT = "content";
    public static final String MODEL_CONTEXT = "context";
    public static final String MODEL_SITEDATA = "sitedata";
    public static final String MODEL_WIDGET_UTILS = "widgetUtils";
    public static final String MODEL_LOCALE = "locale";
    public static final String MODEL_TEMPLATE = "template";
    public static final String MODEL_PAGE = "page";
    public static final String MODEL_PROPERTIES = "properties";
    public static final String MODEL_THEME = "theme";
    public static final String MODEL_DESCRIPTION = "description";
    public static final String MODEL_DESCRIPTION_ID = "descriptionId";
    public static final String MODEL_TITLE = "title";
    public static final String MODEL_TITLE_ID = "titleId";
    public static final String MODEL_ID = "id";
    public static final String MODEL_FORM_INSTANCE = "forminstance";
    public static final String MODEL_FORMDATA = "formdata";
    public static final String MODEL_APP = "app";
    public static final String PROP_HTMLID = "htmlid";
    public static final String MODEL_MESSAGE_METHOD = "msg";
    public static final String MODEL_RESOURCE_URL_METHOD = "resourceurl";
    public static final String MODEL_SURF = "surf";
    public static final String REGION_DIRECTIVE_NAME = "region";
    public static final String COMPONENT_DIRECTIVE_NAME = "component";
    public static final String REGION_INCLUDE_DIRECTIVE_NAME = "regionInclude";
    public static final String COMPONENT_INCLUDE_DIRECTIVE_NAME = "componentInclude";
    public static final String MARKUP_DIRECTIVE_NAME = "markup";
    public static final String SURFBUG_INCLUDE_DIRECTIVE_NAME = "surfbugInclude";
    public static final String RESOURCE_DIRECTIVE_NAME = "res";
    public static final String ANCHOR_DIRECTIVE_NAME = "anchor";
    public static final String PAGE_LINK_DIRECTIVE_NAME = "pagelink";
    public static final String LINK_DIRECTIVE_NAME = "link";
    public static final String MESSAGES_DIRECTIVE_NAME = "generateMessages";
    public static final String CHECKSUM_RESOURCE_DIRECTIVE_NAME = "checksumResource";
    public static final String RELOCATE_JAVASCRIPT_DEPENDENCIES_DIRECTIVE_NAME = "relocateJavaScript";
    public static final String CREATE_WEBSCRIPT_WIDGETS_DIRECTIVE_NAME = "createWidgets";
    public static final String ADD_INLINE_JAVASCRIPT_DIRECTIVE_NAME = "inlineScript";
    public static final String CHROME_DETECTION_DIRECTIVE_NAME = "uniqueIdDiv";
    public static final String STANDALONE_WEBSCRIPT_WRAPPER_DIRECTIVE_NAME = "standalone";
    public static final String SCRIPT_DIRECTIVE_NAME = "script";
    private static final FreemarkerI18NMessageMethod FREEMARKER_MESSAGE_METHOD_INSTANCE = new FreemarkerI18NMessageMethod();
    private static final FreemarkerResourceUrlMethod FREEMARKER_RESOURCE_URL_METHOD_INSTANCE = new FreemarkerResourceUrlMethod();
    private static final ScriptMessageResolver SCRIPT_MESSAGE_INSTANCE = new ScriptMessageResolver();
    private ApplicationContext applicationContext;
    private TaglibFactory taglibFactory;
    private ServletContextHashModel servletContextHashModel;
    private WebFrameworkConfigElement webFrameworkConfigElement;
    private ScriptConfigModel scriptConfigModelInstance;
    private TemplateConfigModel templateConfigModelInstance;
    private RenderService webFrameworkRenderService;
    private DirectiveFactory directiveFactory;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public TaglibFactory getTaglibFactory() {
        return this.taglibFactory;
    }

    public void setTaglibFactory(TaglibFactory taglibFactory) {
        this.taglibFactory = taglibFactory;
    }

    public ServletContextHashModel getServletContextHashModel() {
        return this.servletContextHashModel;
    }

    public void setServletContextHashModel(ServletContextHashModel servletContextHashModel) {
        this.servletContextHashModel = servletContextHashModel;
    }

    public WebFrameworkConfigElement getWebFrameworkConfigElement() {
        return this.webFrameworkConfigElement;
    }

    public void setWebFrameworkConfigElement(WebFrameworkConfigElement webFrameworkConfigElement) {
        this.webFrameworkConfigElement = webFrameworkConfigElement;
    }

    public void setScriptConfigModelInstance(ScriptConfigModel scriptConfigModelInstance) {
        this.scriptConfigModelInstance = scriptConfigModelInstance;
    }

    public void setTemplateConfigModelInstance(TemplateConfigModel templateConfigModelInstance) {
        this.templateConfigModelInstance = templateConfigModelInstance;
    }

    public void setWebFrameworkRenderService(RenderService webFrameworkRenderService) {
        this.webFrameworkRenderService = webFrameworkRenderService;
    }

    public void setDirectiveFactory(DirectiveFactory directiveFactory) {
        this.directiveFactory = directiveFactory;
    }

    private void populateModel(RequestContext context, Map<String, Object> model, ModelObject object) {
        String htmlBindingId;
        Serializable o;
        Component component;
        if (context.getModel() != null && model != null) {
            model.putAll(context.getModel());
        }
        HttpServletRequest req = ServletUtil.getRequest();
        model.put("JspTaglibs", this.taglibFactory);
        model.put("Application", this.servletContextHashModel);
        if (req != null) {
            model.put("Session", ProcessorModelHelper.buildSessionModel(req, context.getResponse()));
            model.put("Request", new HttpRequestHashModel(req, context.getResponse(), ObjectWrapper.DEFAULT_WRAPPER));
            model.put("RequestParameters", new HttpRequestParametersHashModel(req));
        }
        this.setPageProps(context, model);
        this.setTemplateProps(context, model);
        if (object instanceof Component) {
            ScriptForm formInstance = new ScriptForm(context, object);
            model.put(MODEL_FORM_INSTANCE, formInstance);
            if ("POST".equalsIgnoreCase(context.getRequestMethod())) {
                ScriptFormData formData = new ScriptFormData(context, object);
                model.put(MODEL_FORMDATA, formData);
            }
        }
        if (object instanceof SurfBug && (component = ((SurfBug)object).getCurrentComponent()) != null) {
            String path = component.getKey().getSourcePath();
            if (path == null) {
                model.put("storagePath", component.getKey().getStoragePath());
            } else {
                model.put("storagePath", path);
            }
            model.put("componentDebug", component.getModelProperties());
            model.put("componentCustomPropsDebug", component.getCustomProperties());
            WebScript webscript = component.getResolvedWebScript();
            if (webscript != null) {
                String storePath = webscript.getDescription().getStorePath();
                String descPath = webscript.getDescription().getDescPath();
                model.put("resolvedWSStorePath", storePath);
                model.put("resolvedWSDescPath", descPath);
                model.put("resolvedWSBasePath", context.getContextPath() + "/page/script/" + webscript.toString());
            }
        }
        if (object instanceof Chrome && (o = context.getValue("sub-component")) instanceof RenderService.SubComponentData) {
            RenderService.SubComponentData subComponentData = (RenderService.SubComponentData)o;
            this.populateSurfBugData(context, model, subComponentData);
        }
        model.put(MODEL_THEME, context.getThemeId());
        model.put(MODEL_LOCALE, I18NUtil.getLocale().toString());
        ScriptSiteData scriptSiteData = new ScriptSiteData(context, this.applicationContext);
        model.put(MODEL_SITEDATA, scriptSiteData);
        ScriptWidgetUtils scriptWidgetUtils = new ScriptWidgetUtils();
        model.put(MODEL_WIDGET_UTILS, scriptWidgetUtils);
        ScriptRenderContext scriptRequestContext = new ScriptRenderContext(context);
        model.put(MODEL_CONTEXT, scriptRequestContext);
        ScriptSurf scriptSurf = new ScriptSurf(context);
        model.put(MODEL_SURF, scriptSurf);
        if (context.getCurrentObject() != null) {
            ScriptResource scriptResource = new ScriptResource(context, context.getCurrentObject());
            model.put(MODEL_CONTENT, scriptResource);
        }
        ScriptRenderingInstance scriptRenderer = new ScriptRenderingInstance(context, object);
        model.put(MODEL_INSTANCE, scriptRenderer);
        ScriptWebApplication scriptWebApplication = new ScriptWebApplication(context);
        model.put(MODEL_APP, scriptWebApplication);
        if (context.getUser() != null) {
            ScriptUser scriptUser = new ScriptUser(context, context.getUser());
            model.put(MODEL_USER, scriptUser);
        }
        if ((htmlBindingId = (String)((Object)context.getValue(PROP_HTMLID))) != null && htmlBindingId.length() != 0) {
            model.put(PROP_HTMLID, htmlBindingId);
        }
    }

    private void populateSurfBugData(RequestContext context, Map<String, Object> model, RenderService.SubComponentData subComponentData) {
        Serializable o;
        SubComponent subComponent = subComponentData.getSubComponent();
        model.put("surfBugPageId", context.getPageId());
        model.put("surfBugTemplateId", context.getTemplateId());
        model.put("surfBugTemplatePath", context.getTemplate().getTemplateTypeId());
        model.put("surfBugEnabled", context.getValue("surfBugEnabled"));
        model.put("subComponent_id", subComponent.getId());
        model.put("subComponent_parentId", subComponent.getParentId());
        model.put("subComponent_index", subComponent.getIndex());
        model.put("subComponent_processor", subComponent.getProcessorId());
        StringBuilder s = new StringBuilder();
        Iterator<String> i = subComponentData.getContributingSourcePaths().iterator();
        while (i.hasNext()) {
            s.append(i.next());
            if (!i.hasNext()) continue;
            s.append(",");
        }
        model.put("subComponent_paths", s.toString());
        WebScript scWebscript = subComponent.getResolvedWebScript();
        if (scWebscript != null) {
            String storePath = scWebscript.getDescription().getStorePath();
            String descPath = scWebscript.getDescription().getDescPath();
            model.put("subComponent_resolvedWSStorePath", storePath);
            model.put("subComponent_resolvedWSDescPath", descPath);
            model.put("subComponent_resolvedWSBasePath", context.getContextPath() + "/page/script/" + scWebscript.toString());
        }
        if ((o = context.getValue(COMPONENT_DIRECTIVE_NAME)) instanceof Component) {
            Component component = (Component)o;
            String path = component.getKey().getSourcePath();
            if (path == null) {
                model.put("storagePath", component.getKey().getStoragePath());
            } else {
                model.put("storagePath", path);
            }
            model.put("componentDebug", component.getModelProperties());
            model.put("componentCustomPropsDebug", component.getCustomProperties());
            WebScript webscript = component.getResolvedWebScript();
            if (webscript != null) {
                String storePath = webscript.getDescription().getStorePath();
                String descPath = webscript.getDescription().getDescPath();
                model.put("resolvedWSStorePath", storePath);
                model.put("resolvedWSDescPath", descPath);
                model.put("resolvedWSBasePath", context.getContextPath() + "/page/script/" + webscript.toString());
            }
        }
    }

    private void setPageProps(RequestContext context, Map<String, Object> model) {
        Map pageProps;
        ModelObject pageObject = context.getPage();
        if (pageObject != null) {
            pageProps = pageObject.getCustomProperties();
        } else {
            pageObject = context.getTemplate();
            pageProps = Collections.EMPTY_MAP;
        }
        if (pageObject != null) {
            HashMap<String, Object> pageModel = new HashMap<String, Object>(16, 1.0f);
            URLHelper urlHelper = (URLHelper)model.get(MODEL_URL);
            if (urlHelper != null) {
                pageModel.put(MODEL_URL, urlHelper);
            }
            pageModel.put(MODEL_ID, pageObject.getId());
            pageModel.put(MODEL_TITLE, pageObject.getTitle());
            pageModel.put(MODEL_TITLE_ID, pageObject.getTitleId());
            pageModel.put(MODEL_DESCRIPTION, pageObject.getDescription());
            pageModel.put(MODEL_DESCRIPTION_ID, pageObject.getDescriptionId());
            HashMap customProps = new HashMap(pageProps.size());
            customProps.putAll(pageProps);
            pageModel.put(MODEL_PROPERTIES, customProps);
            model.put(MODEL_PAGE, pageModel);
        }
    }

    private void setTemplateProps(RequestContext context, Map<String, Object> model) {
        TemplateInstance template = context.getTemplate();
        if (template != null) {
            HashMap<String, Map> templateModel = new HashMap<String, Map>(1, 1.0f);
            Map<String, Serializable> templateProps = template.getCustomProperties();
            if (templateProps.size() != 0) {
                HashMap<String, Serializable> customProps = new HashMap<String, Serializable>(templateProps.size());
                customProps.putAll(templateProps);
                templateModel.put(MODEL_PROPERTIES, customProps);
            } else {
                templateModel.put(MODEL_PROPERTIES, Collections.EMPTY_MAP);
            }
            model.put(MODEL_TEMPLATE, templateModel);
        }
    }

    public void populateScriptModel(RequestContext context, Map<String, Object> model, ModelObject object) {
        if (model == null) {
            throw new IllegalArgumentException("Model is mandatory.");
        }
        this.populateModel(context, model, object);
        if (object instanceof TemplateInstance) {
            ScriptConfigModel scriptConfigModel = context.getExtendedScriptConfigModel(null);
            if (scriptConfigModel == null) {
                scriptConfigModel = this.scriptConfigModelInstance;
            }
            model.put(MODEL_CONFIG, scriptConfigModel);
            model.put(MODEL_MESSAGE_METHOD, SCRIPT_MESSAGE_INSTANCE);
        }
    }

    public void populateTemplateModel(RequestContext context, Map<String, Object> model, ModelObject object) throws RendererExecutionException, UnsupportedEncodingException {
        URLHelper urlHelper;
        if (model == null) {
            throw new IllegalArgumentException("Model is mandatory.");
        }
        this.populateModel(context, model, object);
        if (object instanceof TemplateInstance) {
            urlHelper = (URLHelper)context.getValue(MODEL_URL);
            if (urlHelper != null) {
                model.put(MODEL_URL, urlHelper);
            }
            StringBuilder head = new StringBuilder(this.webFrameworkRenderService.renderTemplateHeaderAsString(context, object));
            if (this.webFrameworkConfigElement.isSurfBugEnabled()) {
                head.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + context.getContextPath() + "/res/css/surfbug.css" + "\"/>");
                head.append("<script type=\"text/javascript\" src=\"" + context.getContextPath() + "/res/js/surfbug.js" + "\"></script>");
            }
            head.append(context.getExtensionDependencies());
            model.put(MODEL_HEAD, head.toString());
            TemplateConfigModel templateConfigModel = context.getExtendedTemplateConfigModel(null);
            if (templateConfigModel == null) {
                templateConfigModel = this.templateConfigModelInstance;
            }
            model.put(MODEL_CONFIG, templateConfigModel);
            model.put(MODEL_MESSAGE_METHOD, FREEMARKER_MESSAGE_METHOD_INSTANCE);
            model.put(MODEL_RESOURCE_URL_METHOD, FREEMARKER_RESOURCE_URL_METHOD_INSTANCE);
        } else {
            urlHelper = (URLHelper)context.getValue(MODEL_URL);
            if (urlHelper != null) {
                model.put(MODEL_URL, urlHelper);
            }
        }
        if (object instanceof Component || object instanceof SubComponent) {
            TemplateConfigModel templateConfigModel;
            if (model.get(MODEL_URL) == null && (urlHelper = (URLHelper)context.getValue(MODEL_URL)) != null) {
                model.put(MODEL_URL, urlHelper);
            }
            if ((templateConfigModel = context.getExtendedTemplateConfigModel(null)) == null) {
                templateConfigModel = this.templateConfigModelInstance;
            }
            model.put(MODEL_CONFIG, templateConfigModel);
        }
        model.put(COMPONENT_DIRECTIVE_NAME, (Object)new ComponentFreemarkerTagDirective(COMPONENT_DIRECTIVE_NAME, context, object, this.webFrameworkRenderService));
        model.put(COMPONENT_INCLUDE_DIRECTIVE_NAME, (Object)new ChromeIncludeFreeMarkerDirective(COMPONENT_INCLUDE_DIRECTIVE_NAME, context, object, this.webFrameworkRenderService));
        model.put(REGION_INCLUDE_DIRECTIVE_NAME, (Object)new ChromeIncludeFreeMarkerDirective(REGION_INCLUDE_DIRECTIVE_NAME, context, object, this.webFrameworkRenderService));
        model.put(SURFBUG_INCLUDE_DIRECTIVE_NAME, (Object)new SurfBugIncludeFreeMarkerDirective(SURFBUG_INCLUDE_DIRECTIVE_NAME, context, object, this.webFrameworkRenderService));
        ExtensibilityModel extensibilityModel = context.getCurrentExtensibilityModel();
        model.put(REGION_DIRECTIVE_NAME, (Object)new RegionFreemarkerTagDirective(REGION_DIRECTIVE_NAME, extensibilityModel, context, object, this.webFrameworkRenderService));
        model.put(MARKUP_DIRECTIVE_NAME, new MarkupDirective(MARKUP_DIRECTIVE_NAME, extensibilityModel));
        model.put(RESOURCE_DIRECTIVE_NAME, (Object)new ResourceFreemarkerTagDirective(RESOURCE_DIRECTIVE_NAME, context, object, this.webFrameworkRenderService));
        model.put(ANCHOR_DIRECTIVE_NAME, (Object)new AnchorFreeMarkerDirective(ANCHOR_DIRECTIVE_NAME, this.webFrameworkRenderService));
        model.put(PAGE_LINK_DIRECTIVE_NAME, (Object)new LinkFreeMarkerDirective(PAGE_LINK_DIRECTIVE_NAME, this.webFrameworkRenderService));
        model.put("createComponent", (Object)this.directiveFactory.createCreateComponentDirective("createComponent"));
        if (this.webFrameworkConfigElement.useChecksumDependencies() || this.webFrameworkConfigElement.isAggregateDependenciesEnabled()) {
            MessagesDependencyDirective messagesDependencyWebScript = this.directiveFactory.createMessagesDependencyDirective(MESSAGES_DIRECTIVE_NAME, object, extensibilityModel, context);
            messagesDependencyWebScript.setMessagesWebScript(this.directiveFactory.getMessagesWebScript());
            model.put(MESSAGES_DIRECTIVE_NAME, (Object)messagesDependencyWebScript);
            model.put(ADD_INLINE_JAVASCRIPT_DIRECTIVE_NAME, (Object)this.directiveFactory.createAddInlineJavaScriptDirective(ADD_INLINE_JAVASCRIPT_DIRECTIVE_NAME, object, extensibilityModel, context));
            model.put(CREATE_WEBSCRIPT_WIDGETS_DIRECTIVE_NAME, (Object)this.directiveFactory.createCreateWebScriptsDirective(CREATE_WEBSCRIPT_WIDGETS_DIRECTIVE_NAME, object, extensibilityModel, context));
            model.put(RELOCATE_JAVASCRIPT_DEPENDENCIES_DIRECTIVE_NAME, (Object)this.directiveFactory.createRelocateJavaScriptDirective(RELOCATE_JAVASCRIPT_DEPENDENCIES_DIRECTIVE_NAME, object, extensibilityModel, context));
            model.put("outputJavaScript", (Object)this.directiveFactory.createOutputJavaScriptDirective("outputJavaScript", object, extensibilityModel, context));
            model.put("outputCSS", (Object)this.directiveFactory.createOutputCssDirective("outputCSS", object, extensibilityModel, context));
            model.put(SCRIPT_DIRECTIVE_NAME, (Object)this.directiveFactory.createJavaScriptDependencyDirective(SCRIPT_DIRECTIVE_NAME, object, extensibilityModel, context));
            model.put(LINK_DIRECTIVE_NAME, (Object)this.directiveFactory.createCssDependencyDirective(LINK_DIRECTIVE_NAME, object, extensibilityModel, context));
            model.put(CHECKSUM_RESOURCE_DIRECTIVE_NAME, (Object)this.directiveFactory.createChecksumResourceDirective(CHECKSUM_RESOURCE_DIRECTIVE_NAME, object, extensibilityModel, context));
            model.put(CHROME_DETECTION_DIRECTIVE_NAME, (Object)this.directiveFactory.createChromeDetectionDirective(CHROME_DETECTION_DIRECTIVE_NAME, extensibilityModel, this.webFrameworkConfigElement, context));
            model.put(STANDALONE_WEBSCRIPT_WRAPPER_DIRECTIVE_NAME, (Object)this.directiveFactory.createStandaloneWebScriptWrapperDirective(STANDALONE_WEBSCRIPT_WRAPPER_DIRECTIVE_NAME, object, extensibilityModel, context));
            if (this.webFrameworkConfigElement.isDojoEnabled()) {
                model.put("createDojoPage", (Object)this.directiveFactory.createDojoPageDirective("createDojoPage", object, extensibilityModel, context));
            }
        } else {
            model.put(LINK_DIRECTIVE_NAME, (Object)new StyleSheetFreeMarkerDirective(LINK_DIRECTIVE_NAME, context, object, this.webFrameworkRenderService));
        }
    }

    private static HttpSessionHashModel buildSessionModel(HttpServletRequest request, HttpServletResponse response) {
        HttpSessionHashModel model = null;
        HttpSession session = request.getSession(false);
        model = session != null ? new HttpSessionHashModel(session, ObjectWrapper.DEFAULT_WRAPPER) : new HttpSessionHashModel(null, request, response, ObjectWrapper.DEFAULT_WRAPPER);
        return model;
    }

    public static class ScriptMessageResolver {
        public String get(String id) {
            String result = null;
            if (id != null && id.length() != 0) {
                result = this.resolveMessage(id, new Object[0]);
            }
            return result != null ? result : "";
        }

        public String get(String id, Scriptable args) {
            String result = null;
            if (id != null && id.length() != 0) {
                Object params = ScriptValueConverter.unwrapValue((Object)args);
                result = params instanceof List ? this.resolveMessage(id, ((List)params).toArray()) : this.resolveMessage(id, new Object[0]);
            }
            return result != null ? result : "";
        }

        private final String resolveMessage(String id, Object ... args) {
            String result = I18NUtil.getMessage((String)id);
            if (args.length == 0) {
                if (result == null) {
                    result = id;
                }
            } else {
                result = result != null ? MessageFormat.format(result, args) : id;
            }
            return result;
        }
    }
}

