/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.extensions.webscripts.ResourceStore;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.context.support.ServletContextResource;
import org.springframework.web.context.support.ServletContextResourcePatternResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebApplicationStore
extends ResourceStore
implements ServletContextAware {
    private static Log logger = LogFactory.getLog(WebApplicationStore.class);
    private static String[] forbiddenPaths = new String[]{"/classes", "/WEB-INF/classes", "/lib", "/WEB-INF/lib"};
    private ServletContext servletContext;

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    protected ServletContext getServletContext() {
        return this.servletContext;
    }

    @Override
    public PathMatchingResourcePatternResolver getResourceResolver() {
        if (this.resolver == null) {
            this.resolver = new ServletContextResourcePatternResolver(this.getServletContext());
        }
        return this.resolver;
    }

    @Override
    protected boolean isForbidden(String documentPath) {
        boolean forbidden = false;
        if (!(documentPath = documentPath.replace("\\", "/")).startsWith("/")) {
            documentPath = "/" + documentPath;
        }
        if (documentPath.endsWith("/")) {
            documentPath = documentPath.substring(0, documentPath.length() - 1);
        }
        for (String forbiddenPath : forbiddenPaths) {
            if (!documentPath.startsWith(forbiddenPath)) continue;
            forbidden = true;
        }
        return forbidden;
    }

    @Override
    public boolean isSecure() {
        return true;
    }

    public String toString() {
        return "webapp:" + this.getBasePath();
    }

    public boolean isReadOnly() {
        return true;
    }

    @Override
    protected List<String> matchDocumentPaths(String documentPathPattern) throws IOException {
        Resource[] resources = this.getDocumentResources(documentPathPattern);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < resources.length; ++i) {
            String documentPath;
            String resourcePath = ((ServletContextResource)resources[i]).getPathWithinContext();
            if (!resourcePath.startsWith(this.getRoot()) || (documentPath = this.toDocumentPath(resourcePath)) == null || this.isForbidden(documentPath)) continue;
            list.add(documentPath);
        }
        return list;
    }
}

