/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.finance;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.Category;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.Kind;
import com.google.gdata.data.finance.PortfolioData;
import com.google.gdata.data.finance.PortfolioFeedLink;

@Kind.Term(value="http://schemas.google.com/finance/2007#portfolio")
public class PortfolioEntry
extends BaseEntry<PortfolioEntry> {
    public static final String KIND = "http://schemas.google.com/finance/2007#portfolio";
    public static final Category CATEGORY = new Category("http://schemas.google.com/g/2005#kind", "http://schemas.google.com/finance/2007#portfolio");

    public PortfolioEntry() {
        this.getCategories().add(CATEGORY);
    }

    public PortfolioEntry(BaseEntry<?> sourceEntry) {
        super(sourceEntry);
    }

    public void declareExtensions(ExtensionProfile extProfile) {
        if (extProfile.isDeclared(PortfolioEntry.class)) {
            return;
        }
        super.declareExtensions(extProfile);
        extProfile.declare(PortfolioEntry.class, PortfolioFeedLink.class);
        new PortfolioFeedLink().declareExtensions(extProfile);
        extProfile.declare(PortfolioEntry.class, PortfolioData.getDefaultDescription(true, false));
        new PortfolioData().declareExtensions(extProfile);
    }

    public PortfolioFeedLink getFeedLink() {
        return (PortfolioFeedLink)this.getExtension(PortfolioFeedLink.class);
    }

    public void setFeedLink(PortfolioFeedLink feedLink) {
        if (feedLink == null) {
            this.removeExtension(PortfolioFeedLink.class);
        } else {
            this.setExtension((Extension)feedLink);
        }
    }

    public boolean hasFeedLink() {
        return this.hasExtension(PortfolioFeedLink.class);
    }

    public PortfolioData getPortfolioData() {
        return (PortfolioData)this.getExtension(PortfolioData.class);
    }

    public void setPortfolioData(PortfolioData portfolioData) {
        if (portfolioData == null) {
            this.removeExtension(PortfolioData.class);
        } else {
            this.setExtension((Extension)portfolioData);
        }
    }

    public boolean hasPortfolioData() {
        return this.hasExtension(PortfolioData.class);
    }

    protected void validate() {
    }

    public String toString() {
        return "{PortfolioEntry " + super.toString() + "}";
    }
}

