/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client.appsforyourdomain;

import com.google.gdata.client.appsforyourdomain.AppsPropertyService;
import com.google.gdata.data.Link;
import com.google.gdata.data.appsforyourdomain.AppsForYourDomainErrorCode;
import com.google.gdata.data.appsforyourdomain.AppsForYourDomainException;
import com.google.gdata.data.appsforyourdomain.generic.GenericEntry;
import com.google.gdata.data.appsforyourdomain.generic.GenericFeed;
import com.google.gdata.util.AuthenticationException;
import com.google.gdata.util.ServiceException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;

public class AppsGroupsService
extends AppsPropertyService {
    public static final String BASE_URL = "https://apps-apis.google.com/a/feeds/group/2.0/";
    public final String baseDomainUrl;
    public static final String APPS_PROP_GROUP_ID = "groupId";
    public static final String APPS_PROP_GROUP_NAME = "groupName";
    public static final String APPS_PROP_GROUP_DESC = "description";
    public static final String APPS_PROP_GROUP_PERMISSION = "emailPermission";
    public static final String APPS_PROP_GROUP_MEMBER_ID = "memberId";
    public static final String APPS_PROP_GROUP_ROLE = "role";
    public static final String APPS_PROP_GROUP_EMAIL = "email";

    public AppsGroupsService(String adminUser, String adminPassword, String domain, String applicationName) throws AuthenticationException {
        this(domain, applicationName);
        this.setUserCredentials(adminUser, adminPassword);
    }

    public AppsGroupsService(String domain, String applicationName) throws AuthenticationException {
        super(applicationName);
        this.baseDomainUrl = BASE_URL + domain + "/";
    }

    public GenericFeed getNextPage(Link atomLink) throws AppsForYourDomainException, MalformedURLException, IOException, ServiceException {
        return this.getFeed(new URL(atomLink.getHref()), GenericFeed.class);
    }

    public boolean doesEntityExist(String feedUrlSuffix) throws AppsForYourDomainException, MalformedURLException, IOException, ServiceException {
        try {
            GenericEntry entry = this.getEntry(new URL(this.baseDomainUrl + feedUrlSuffix), GenericEntry.class);
            return entry.getAllProperties().size() > 0;
        }
        catch (AppsForYourDomainException e) {
            if (e.getErrorCode() == AppsForYourDomainErrorCode.EntityDoesNotExist) {
                return false;
            }
            throw e;
        }
    }

    public boolean isMember(String groupId, String memberId) throws AppsForYourDomainException, MalformedURLException, IOException, ServiceException {
        return this.doesEntityExist(groupId + "/member/" + memberId);
    }

    public boolean isOwner(String groupId, String email) throws AppsForYourDomainException, MalformedURLException, IOException, ServiceException {
        return this.doesEntityExist(groupId + "/owner/" + email);
    }

    public GenericEntry createGroup(String groupId, String groupName, String groupDescription, String emailPermission) throws AppsForYourDomainException, MalformedURLException, IOException, ServiceException {
        GenericEntry entry = new GenericEntry();
        entry.addProperty(APPS_PROP_GROUP_ID, groupId);
        entry.addProperty(APPS_PROP_GROUP_NAME, groupName);
        entry.addProperty(APPS_PROP_GROUP_DESC, groupDescription);
        entry.addProperty(APPS_PROP_GROUP_PERMISSION, emailPermission);
        return this.insert(new URL(this.baseDomainUrl), entry);
    }

    public GenericEntry updateGroup(String groupId, String groupName, String groupDescription, String emailPermission) throws AppsForYourDomainException, MalformedURLException, IOException, ServiceException {
        GenericEntry entry = new GenericEntry();
        if (groupName != null && !groupName.equals("")) {
            entry.addProperty(APPS_PROP_GROUP_NAME, groupName);
        }
        if (groupDescription != null && !groupDescription.equals("")) {
            entry.addProperty(APPS_PROP_GROUP_DESC, groupDescription);
        }
        if (emailPermission != null && !emailPermission.equals("")) {
            entry.addProperty(APPS_PROP_GROUP_PERMISSION, emailPermission);
        }
        if (entry.getAllProperties().size() == 0) {
            return this.retrieveGroup(groupId);
        }
        return this.update(new URL(this.baseDomainUrl + groupId), entry);
    }

    public void deleteGroup(String groupId) throws AppsForYourDomainException, MalformedURLException, IOException, ServiceException {
        this.delete(new URL(this.baseDomainUrl + groupId));
    }

    public GenericEntry retrieveGroup(String groupId) throws AppsForYourDomainException, MalformedURLException, IOException, ServiceException {
        return this.getEntry(new URL(this.baseDomainUrl + groupId), GenericEntry.class);
    }

    public GenericEntry addMemberToGroup(String groupId, String memberName) throws AppsForYourDomainException, MalformedURLException, IOException, ServiceException {
        GenericEntry entry = new GenericEntry();
        entry.addProperty(APPS_PROP_GROUP_MEMBER_ID, memberName);
        return this.insert(new URL(this.baseDomainUrl + groupId + "/member"), entry);
    }

    public void deleteMemberFromGroup(String groupId, String memberName) throws AppsForYourDomainException, MalformedURLException, IOException, ServiceException {
        this.delete(new URL(this.baseDomainUrl + groupId + "/member/" + memberName));
    }

    public GenericFeed retrieveAllMembers(String groupId) throws AppsForYourDomainException, MalformedURLException, IOException, ServiceException {
        return this.getFeed(new URL(this.baseDomainUrl + groupId + "/member"), GenericFeed.class);
    }

    public GenericFeed retrievePageOfMembers(Link next) throws AppsForYourDomainException, MalformedURLException, IOException, ServiceException {
        return this.getNextPage(next);
    }

    public GenericEntry addOwnerToGroup(String groupId, String ownerName) throws AppsForYourDomainException, MalformedURLException, IOException, ServiceException {
        GenericEntry entry = new GenericEntry();
        entry.addProperty(APPS_PROP_GROUP_EMAIL, ownerName);
        return this.insert(new URL(this.baseDomainUrl + groupId + "/owner"), entry);
    }

    public void removeOwnerFromGroup(String email, String groupId) throws AppsForYourDomainException, MalformedURLException, IOException, ServiceException {
        this.delete(new URL(this.baseDomainUrl + groupId + "/owner/" + email));
    }

    public GenericFeed retrieveAllGroups() throws AppsForYourDomainException, MalformedURLException, IOException, ServiceException {
        return this.getFeed(new URL(this.baseDomainUrl), GenericFeed.class);
    }

    public GenericFeed retrievePageOfGroups(Link next) throws AppsForYourDomainException, MalformedURLException, IOException, ServiceException {
        return this.getNextPage(next);
    }

    public GenericFeed retrieveGroups(String memberName, boolean directOnly) throws AppsForYourDomainException, MalformedURLException, IOException, ServiceException {
        return this.getFeed(new URL(this.baseDomainUrl + "?member=" + memberName + "&directOnly=" + String.valueOf(directOnly)), GenericFeed.class);
    }

    public GenericFeed retreiveGroupOwners(String groupId) throws AppsForYourDomainException, MalformedURLException, IOException, ServiceException {
        return this.getFeed(new URL(this.baseDomainUrl + groupId + "/owner"), GenericFeed.class);
    }

    public List<GenericEntry> retrieveAllPagesOfGroups() throws MalformedURLException, IOException, ServiceException {
        return this.getAllPages(new URL(this.baseDomainUrl), GenericFeed.class);
    }
}

