/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.appsforyourdomain;

import com.google.gdata.data.appsforyourdomain.AppsForYourDomainErrorCode;
import com.google.gdata.util.ContentType;
import com.google.gdata.util.ServiceException;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class AppsForYourDomainException
extends ServiceException {
    protected AppsForYourDomainErrorCode errorCode;
    protected String invalidInput;
    protected static DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

    public AppsForYourDomainException(AppsForYourDomainErrorCode errorCode, String invalidInput, int httpReturnCode) {
        super("AppsForYourDomainException");
        this.errorCode = errorCode == null ? (httpReturnCode >= 400 && httpReturnCode < 500 ? AppsForYourDomainErrorCode.InvalidValue : AppsForYourDomainErrorCode.UnknownError) : errorCode;
        this.invalidInput = invalidInput;
    }

    public AppsForYourDomainException(AppsForYourDomainErrorCode errorCode, String invalidInput) {
        this(errorCode, invalidInput, 0);
    }

    public AppsForYourDomainException(AppsForYourDomainErrorCode errorCode) {
        this(errorCode, "");
    }

    public AppsForYourDomainException() {
        this(AppsForYourDomainErrorCode.UnknownError);
    }

    public AppsForYourDomainErrorCode getErrorCode() {
        return this.errorCode;
    }

    public String getInvalidInput() {
        return this.invalidInput;
    }

    public String toString() {
        return this.errorCode.toString() + ": " + this.invalidInput;
    }

    public static AppsForYourDomainException narrow(ServiceException se) {
        if (se.getResponseContentType() == null || se.getResponseBody() == null) {
            return null;
        }
        if (se.getHttpErrorCodeOverride() == 502) {
            return new AppsForYourDomainException(AppsForYourDomainErrorCode.ServerBusy, "The server is busy and could not complete your request.  Please try again in 30 seconds.");
        }
        if (se.getResponseContentType().equals((Object)new ContentType("text/xml")) && se.getResponseBody().contains("AppsForYourDomainErrors")) {
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.parse(new InputSource(new StringReader(se.getResponseBody())));
                Element root = document.getDocumentElement();
                NodeList errorList = root.getElementsByTagName("error");
                Node error = errorList.item(0);
                NamedNodeMap attributes = error.getAttributes();
                int errorCode = Integer.parseInt(attributes.getNamedItem("errorCode").getNodeValue());
                String invalidInput = attributes.getNamedItem("invalidInput").getNodeValue();
                AppsForYourDomainException exception = new AppsForYourDomainException(AppsForYourDomainErrorCode.getEnumFromInt(errorCode), invalidInput, se.getHttpErrorCodeOverride());
                return exception;
            }
            catch (NumberFormatException e) {
                return null;
            }
            catch (ParserConfigurationException e) {
                return null;
            }
            catch (SAXException e) {
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }
}

