/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.ProcessEngineConfiguration;
import org.activiti.engine.ProcessEngineInfo;
import org.activiti.engine.impl.ProcessEngineInfoImpl;
import org.activiti.engine.impl.util.IoUtil;
import org.activiti.engine.impl.util.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProcessEngines {
    private static Logger log = Logger.getLogger(ProcessEngines.class.getName());
    public static final String NAME_DEFAULT = "default";
    protected static boolean isInitialized = false;
    protected static Map<String, ProcessEngine> processEngines = new HashMap<String, ProcessEngine>();
    protected static Map<String, ProcessEngineInfo> processEngineInfosByName = new HashMap<String, ProcessEngineInfo>();
    protected static Map<String, ProcessEngineInfo> processEngineInfosByResourceUrl = new HashMap<String, ProcessEngineInfo>();
    protected static List<ProcessEngineInfo> processEngineInfos = new ArrayList<ProcessEngineInfo>();

    public static synchronized void init() {
        if (!isInitialized) {
            if (processEngines == null) {
                processEngines = new HashMap<String, ProcessEngine>();
            }
            ClassLoader classLoader = ReflectUtil.getClassLoader();
            Enumeration<URL> resources = null;
            try {
                resources = classLoader.getResources("activiti.cfg.xml");
            }
            catch (IOException e) {
                throw new ActivitiException("problem retrieving activiti.cfg.xml resources on the classpath: " + System.getProperty("java.class.path"), e);
            }
            HashSet<URL> configUrls = new HashSet<URL>();
            while (resources.hasMoreElements()) {
                configUrls.add(resources.nextElement());
            }
            for (URL resource : configUrls) {
                ProcessEngines.initProcessEnginFromResource(resource);
            }
            try {
                resources = classLoader.getResources("activiti-context.xml");
            }
            catch (IOException e) {
                throw new ActivitiException("problem retrieving activiti-context.xml resources on the classpath: " + System.getProperty("java.class.path"), e);
            }
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                ProcessEngines.initProcessEngineFromSpringResource(resource);
            }
            isInitialized = true;
        } else {
            log.info("Process engines already initialized");
        }
    }

    protected static void initProcessEngineFromSpringResource(URL resource) {
        try {
            Class<?> springConfigurationHelperClass = ReflectUtil.loadClass("org.activiti.spring.SpringConfigurationHelper");
            Method method = springConfigurationHelperClass.getMethod("buildProcessEngine", URL.class);
            ProcessEngine processEngine = (ProcessEngine)method.invoke(null, resource);
            String processEngineName = processEngine.getName();
            ProcessEngineInfoImpl processEngineInfo = new ProcessEngineInfoImpl(processEngineName, resource.toString(), null);
            processEngineInfosByName.put(processEngineName, processEngineInfo);
            processEngineInfosByResourceUrl.put(resource.toString(), processEngineInfo);
        }
        catch (Exception e) {
            throw new ActivitiException("couldn't initialize process engine from spring configuration resource " + resource.toString() + ": " + e.getMessage(), e);
        }
    }

    public static void registerProcessEngine(ProcessEngine processEngine) {
        processEngines.put(processEngine.getName(), processEngine);
    }

    public static void unregister(ProcessEngine processEngine) {
        processEngines.remove(processEngine.getName());
    }

    private static ProcessEngineInfo initProcessEnginFromResource(URL resourceUrl) {
        ProcessEngineInfo processEngineInfo = processEngineInfosByResourceUrl.get(resourceUrl);
        if (processEngineInfo != null) {
            processEngineInfos.remove(processEngineInfo);
            if (processEngineInfo.getException() == null) {
                String processEngineName = processEngineInfo.getName();
                processEngines.remove(processEngineName);
                processEngineInfosByName.remove(processEngineName);
            }
            processEngineInfosByResourceUrl.remove(processEngineInfo.getResourceUrl());
        }
        String resourceUrlString = resourceUrl.toString();
        try {
            log.info("initializing process engine for resource " + resourceUrl);
            ProcessEngine processEngine = ProcessEngines.buildProcessEngine(resourceUrl);
            String processEngineName = processEngine.getName();
            log.info("initialised process engine " + processEngineName);
            processEngineInfo = new ProcessEngineInfoImpl(processEngineName, resourceUrlString, null);
            processEngines.put(processEngineName, processEngine);
            processEngineInfosByName.put(processEngineName, processEngineInfo);
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, "Exception while initializing process engine :" + e.getMessage(), e);
            processEngineInfo = new ProcessEngineInfoImpl(null, resourceUrlString, ProcessEngines.getExceptionString(e));
        }
        processEngineInfosByResourceUrl.put(resourceUrlString, processEngineInfo);
        processEngineInfos.add(processEngineInfo);
        return processEngineInfo;
    }

    private static String getExceptionString(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    private static ProcessEngine buildProcessEngine(URL resource) {
        InputStream inputStream = null;
        try {
            inputStream = resource.openStream();
            ProcessEngineConfiguration processEngineConfiguration = ProcessEngineConfiguration.createProcessEngineConfigurationFromInputStream(inputStream);
            ProcessEngine processEngine = processEngineConfiguration.buildProcessEngine();
            return processEngine;
        }
        catch (IOException e) {
            throw new ActivitiException("couldn't open resource stream: " + e.getMessage(), e);
        }
        finally {
            IoUtil.closeSilently(inputStream);
        }
    }

    public static List<ProcessEngineInfo> getProcessEngineInfos() {
        return processEngineInfos;
    }

    public static ProcessEngineInfo getProcessEngineInfo(String processEngineName) {
        return processEngineInfosByName.get(processEngineName);
    }

    public static ProcessEngine getDefaultProcessEngine() {
        return ProcessEngines.getProcessEngine(NAME_DEFAULT);
    }

    public static ProcessEngine getProcessEngine(String processEngineName) {
        if (!isInitialized) {
            ProcessEngines.init();
        }
        return processEngines.get(processEngineName);
    }

    public static ProcessEngineInfo retry(String resourceUrl) {
        log.fine("retying initializing of resource " + resourceUrl);
        try {
            return ProcessEngines.initProcessEnginFromResource(new URL(resourceUrl));
        }
        catch (MalformedURLException e) {
            throw new ActivitiException("invalid url: " + resourceUrl, e);
        }
    }

    public static Map<String, ProcessEngine> getProcessEngines() {
        return processEngines;
    }

    public static synchronized void destroy() {
        if (isInitialized) {
            HashMap<String, ProcessEngine> engines = new HashMap<String, ProcessEngine>(processEngines);
            processEngines = new HashMap<String, ProcessEngine>();
            for (String processEngineName : engines.keySet()) {
                ProcessEngine processEngine = (ProcessEngine)engines.get(processEngineName);
                try {
                    processEngine.close();
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "exception while closing " + (processEngineName == null ? "the default process engine" : "process engine " + processEngineName), e);
                }
            }
            processEngineInfosByName.clear();
            processEngineInfosByResourceUrl.clear();
            processEngineInfos.clear();
            isInitialized = false;
        }
    }
}

