/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl;

import java.io.Serializable;
import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.AbstractQuery;
import org.activiti.engine.impl.DeploymentQueryProperty;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.DeploymentQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentQueryImpl
extends AbstractQuery<DeploymentQuery, Deployment>
implements DeploymentQuery,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String deploymentId;
    protected String name;
    protected String nameLike;

    public DeploymentQueryImpl() {
    }

    public DeploymentQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public DeploymentQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public DeploymentQueryImpl deploymentId(String deploymentId) {
        if (deploymentId == null) {
            throw new ActivitiException("Deployment id is null");
        }
        this.deploymentId = deploymentId;
        return this;
    }

    @Override
    public DeploymentQueryImpl deploymentName(String deploymentName) {
        if (deploymentName == null) {
            throw new ActivitiException("deploymentName is null");
        }
        this.name = deploymentName;
        return this;
    }

    @Override
    public DeploymentQueryImpl deploymentNameLike(String nameLike) {
        if (nameLike == null) {
            throw new ActivitiException("deploymentNameLike is null");
        }
        this.nameLike = nameLike;
        return this;
    }

    @Override
    public DeploymentQuery orderByDeploymentId() {
        return (DeploymentQuery)this.orderBy(DeploymentQueryProperty.DEPLOYMENT_ID);
    }

    @Override
    public DeploymentQuery orderByDeploymenTime() {
        return (DeploymentQuery)this.orderBy(DeploymentQueryProperty.DEPLOY_TIME);
    }

    @Override
    public DeploymentQuery orderByDeploymentName() {
        return (DeploymentQuery)this.orderBy(DeploymentQueryProperty.DEPLOYMENT_NAME);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getDeploymentManager().findDeploymentCountByQueryCriteria(this);
    }

    @Override
    public List<Deployment> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        return commandContext.getDeploymentManager().findDeploymentsByQueryCriteria(this, page);
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public String getName() {
        return this.name;
    }

    public String getNameLike() {
        return this.nameLike;
    }
}

