/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl;

import java.io.Serializable;
import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.AbstractQuery;
import org.activiti.engine.impl.EventSubscriptionQueryProperty;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventSubscriptionQueryImpl
extends AbstractQuery<EventSubscriptionQueryImpl, EventSubscriptionEntity>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String eventSubscriptionId;
    protected String eventName;
    protected String eventType;
    protected String executionId;
    protected String processInstanceId;
    protected String activityId;

    public EventSubscriptionQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public EventSubscriptionQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    public EventSubscriptionQueryImpl eventSubscriptionId(String id) {
        if (this.eventSubscriptionId == null) {
            throw new ActivitiException("Provided svent subscription id is null");
        }
        this.eventSubscriptionId = id;
        return this;
    }

    public EventSubscriptionQueryImpl eventName(String eventName) {
        if (eventName == null) {
            throw new ActivitiException("Provided event name is null");
        }
        this.eventName = eventName;
        return this;
    }

    public EventSubscriptionQueryImpl executionId(String executionId) {
        if (executionId == null) {
            throw new ActivitiException("Provided execution id is null");
        }
        this.executionId = executionId;
        return this;
    }

    public EventSubscriptionQueryImpl processInstanceId(String processInstanceId) {
        if (processInstanceId == null) {
            throw new ActivitiException("Provided process instance id is null");
        }
        this.processInstanceId = processInstanceId;
        return this;
    }

    public EventSubscriptionQueryImpl activityId(String activityId) {
        if (activityId == null) {
            throw new ActivitiException("Provided activity id is null");
        }
        this.activityId = activityId;
        return this;
    }

    public EventSubscriptionQueryImpl eventType(String eventType) {
        if (eventType == null) {
            throw new ActivitiException("Provided event type is null");
        }
        this.eventType = eventType;
        return this;
    }

    public EventSubscriptionQueryImpl orderByCreated() {
        return (EventSubscriptionQueryImpl)this.orderBy(EventSubscriptionQueryProperty.CREATED);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getEventSubscriptionManager().findEventSubscriptionCountByQueryCriteria(this);
    }

    @Override
    public List<EventSubscriptionEntity> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        return commandContext.getEventSubscriptionManager().findEventSubscriptionsByQueryCriteria(this, page);
    }

    public String getEventSubscriptionId() {
        return this.eventSubscriptionId;
    }

    public String getEventName() {
        return this.eventName;
    }

    public String getEventType() {
        return this.eventType;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getActivityId() {
        return this.activityId;
    }
}

