/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.AbstractQuery;
import org.activiti.engine.impl.JobQueryProperty;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.activiti.engine.impl.util.ClockUtil;
import org.activiti.engine.runtime.Job;
import org.activiti.engine.runtime.JobQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobQueryImpl
extends AbstractQuery<JobQuery, Job>
implements JobQuery,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String processInstanceId;
    protected String executionId;
    protected boolean retriesLeft;
    protected boolean executable;
    protected boolean onlyTimers;
    protected boolean onlyMessages;
    protected Date duedateHigherThen;
    protected Date duedateLowerThen;
    protected Date duedateHigherThenOrEqual;
    protected Date duedateLowerThenOrEqual;
    protected boolean withException;
    protected String exceptionMessage;

    public JobQueryImpl() {
    }

    public JobQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public JobQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public JobQuery jobId(String jobId) {
        if (jobId == null) {
            throw new ActivitiException("Provided job id is null");
        }
        this.id = jobId;
        return this;
    }

    @Override
    public JobQueryImpl processInstanceId(String processInstanceId) {
        if (processInstanceId == null) {
            throw new ActivitiException("Provided process instance id is null");
        }
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Override
    public JobQueryImpl executionId(String executionId) {
        if (executionId == null) {
            throw new ActivitiException("Provided execution id is null");
        }
        this.executionId = executionId;
        return this;
    }

    @Override
    public JobQuery withRetriesLeft() {
        this.retriesLeft = true;
        return this;
    }

    @Override
    public JobQuery executable() {
        this.executable = true;
        return this;
    }

    @Override
    public JobQuery timers() {
        if (this.onlyMessages) {
            throw new ActivitiException("Cannot combine onlyTimers() with onlyMessages() in the same query");
        }
        this.onlyTimers = true;
        return this;
    }

    @Override
    public JobQuery messages() {
        if (this.onlyTimers) {
            throw new ActivitiException("Cannot combine onlyTimers() with onlyMessages() in the same query");
        }
        this.onlyMessages = true;
        return this;
    }

    @Override
    public JobQuery duedateHigherThen(Date date) {
        if (date == null) {
            throw new ActivitiException("Provided date is null");
        }
        this.duedateHigherThen = date;
        return this;
    }

    @Override
    public JobQuery duedateHigherThenOrEquals(Date date) {
        if (date == null) {
            throw new ActivitiException("Provided date is null");
        }
        this.duedateHigherThenOrEqual = date;
        return this;
    }

    @Override
    public JobQuery duedateLowerThen(Date date) {
        if (date == null) {
            throw new ActivitiException("Provided date is null");
        }
        this.duedateLowerThen = date;
        return this;
    }

    @Override
    public JobQuery duedateLowerThenOrEquals(Date date) {
        if (date == null) {
            throw new ActivitiException("Provided date is null");
        }
        this.duedateLowerThenOrEqual = date;
        return this;
    }

    @Override
    public JobQuery withException() {
        this.withException = true;
        return this;
    }

    @Override
    public JobQuery exceptionMessage(String exceptionMessage) {
        if (exceptionMessage == null) {
            throw new ActivitiException("Provided exception message is null");
        }
        this.exceptionMessage = exceptionMessage;
        return this;
    }

    @Override
    public JobQuery orderByJobDuedate() {
        return (JobQuery)this.orderBy(JobQueryProperty.DUEDATE);
    }

    @Override
    public JobQuery orderByExecutionId() {
        return (JobQuery)this.orderBy(JobQueryProperty.EXECUTION_ID);
    }

    @Override
    public JobQuery orderByJobId() {
        return (JobQuery)this.orderBy(JobQueryProperty.JOB_ID);
    }

    @Override
    public JobQuery orderByProcessInstanceId() {
        return (JobQuery)this.orderBy(JobQueryProperty.PROCESS_INSTANCE_ID);
    }

    @Override
    public JobQuery orderByJobRetries() {
        return (JobQuery)this.orderBy(JobQueryProperty.RETRIES);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getJobManager().findJobCountByQueryCriteria(this);
    }

    @Override
    public List<Job> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        return commandContext.getJobManager().findJobsByQueryCriteria(this, page);
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public boolean getRetriesLeft() {
        return this.retriesLeft;
    }

    public boolean getExecutable() {
        return this.executable;
    }

    public Date getNow() {
        return ClockUtil.getCurrentTime();
    }

    public boolean isWithException() {
        return this.withException;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }
}

