/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl;

import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.AbstractQuery;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.ProcessDefinitionQueryProperty;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.activiti.engine.impl.persistence.entity.SuspensionState;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.repository.ProcessDefinitionQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessDefinitionQueryImpl
extends AbstractQuery<ProcessDefinitionQuery, ProcessDefinition>
implements ProcessDefinitionQuery {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String category;
    protected String categoryLike;
    protected String name;
    protected String nameLike;
    protected String deploymentId;
    protected String key;
    protected String keyLike;
    protected String resourceName;
    protected String resourceNameLike;
    protected Integer version;
    protected boolean latest = false;
    protected SuspensionState suspensionState;
    protected String authorizationUserId;
    protected String procDefId;
    protected String eventSubscriptionName;
    protected String eventSubscriptionType;

    public ProcessDefinitionQueryImpl() {
    }

    public ProcessDefinitionQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public ProcessDefinitionQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public ProcessDefinitionQueryImpl processDefinitionId(String processDefinitionId) {
        this.id = processDefinitionId;
        return this;
    }

    @Override
    public ProcessDefinitionQueryImpl processDefinitionCategory(String category) {
        if (category == null) {
            throw new ActivitiException("category is null");
        }
        this.category = category;
        return this;
    }

    @Override
    public ProcessDefinitionQueryImpl processDefinitionCategoryLike(String categoryLike) {
        if (categoryLike == null) {
            throw new ActivitiException("categoryLike is null");
        }
        this.categoryLike = categoryLike;
        return this;
    }

    @Override
    public ProcessDefinitionQueryImpl processDefinitionName(String name) {
        if (name == null) {
            throw new ActivitiException("name is null");
        }
        this.name = name;
        return this;
    }

    @Override
    public ProcessDefinitionQueryImpl processDefinitionNameLike(String nameLike) {
        if (nameLike == null) {
            throw new ActivitiException("nameLike is null");
        }
        this.nameLike = nameLike;
        return this;
    }

    @Override
    public ProcessDefinitionQueryImpl deploymentId(String deploymentId) {
        if (deploymentId == null) {
            throw new ActivitiException("id is null");
        }
        this.deploymentId = deploymentId;
        return this;
    }

    @Override
    public ProcessDefinitionQueryImpl processDefinitionKey(String key) {
        if (key == null) {
            throw new ActivitiException("key is null");
        }
        this.key = key;
        return this;
    }

    @Override
    public ProcessDefinitionQueryImpl processDefinitionKeyLike(String keyLike) {
        if (keyLike == null) {
            throw new ActivitiException("keyLike is null");
        }
        this.keyLike = keyLike;
        return this;
    }

    @Override
    public ProcessDefinitionQueryImpl processDefinitionResourceName(String resourceName) {
        if (resourceName == null) {
            throw new ActivitiException("resourceName is null");
        }
        this.resourceName = resourceName;
        return this;
    }

    @Override
    public ProcessDefinitionQueryImpl processDefinitionResourceNameLike(String resourceNameLike) {
        if (resourceNameLike == null) {
            throw new ActivitiException("resourceNameLike is null");
        }
        this.resourceNameLike = resourceNameLike;
        return this;
    }

    @Override
    public ProcessDefinitionQueryImpl processDefinitionVersion(Integer version) {
        if (version == null) {
            throw new ActivitiException("version is null");
        }
        if (version <= 0) {
            throw new ActivitiException("version must be positive");
        }
        this.version = version;
        return this;
    }

    @Override
    public ProcessDefinitionQueryImpl latestVersion() {
        this.latest = true;
        return this;
    }

    @Override
    public ProcessDefinitionQuery active() {
        this.suspensionState = SuspensionState.ACTIVE;
        return this;
    }

    @Override
    public ProcessDefinitionQuery suspended() {
        this.suspensionState = SuspensionState.SUSPENDED;
        return this;
    }

    @Override
    public ProcessDefinitionQuery messageEventSubscription(String messageName) {
        return this.eventSubscription("message", messageName);
    }

    @Override
    public ProcessDefinitionQuery messageEventSubscriptionName(String messageName) {
        return this.eventSubscription("message", messageName);
    }

    public ProcessDefinitionQuery processDefinitionStarter(String procDefId) {
        this.procDefId = procDefId;
        return this;
    }

    public ProcessDefinitionQuery eventSubscription(String eventType, String eventName) {
        if (eventName == null) {
            throw new ActivitiException("event name is null");
        }
        if (eventType == null) {
            throw new ActivitiException("event type is null");
        }
        this.eventSubscriptionType = eventType;
        this.eventSubscriptionName = eventName;
        return this;
    }

    @Override
    public ProcessDefinitionQuery orderByDeploymentId() {
        return (ProcessDefinitionQuery)this.orderBy(ProcessDefinitionQueryProperty.DEPLOYMENT_ID);
    }

    @Override
    public ProcessDefinitionQuery orderByProcessDefinitionKey() {
        return (ProcessDefinitionQuery)this.orderBy(ProcessDefinitionQueryProperty.PROCESS_DEFINITION_KEY);
    }

    @Override
    public ProcessDefinitionQuery orderByProcessDefinitionCategory() {
        return (ProcessDefinitionQuery)this.orderBy(ProcessDefinitionQueryProperty.PROCESS_DEFINITION_CATEGORY);
    }

    @Override
    public ProcessDefinitionQuery orderByProcessDefinitionId() {
        return (ProcessDefinitionQuery)this.orderBy(ProcessDefinitionQueryProperty.PROCESS_DEFINITION_ID);
    }

    @Override
    public ProcessDefinitionQuery orderByProcessDefinitionVersion() {
        return (ProcessDefinitionQuery)this.orderBy(ProcessDefinitionQueryProperty.PROCESS_DEFINITION_VERSION);
    }

    @Override
    public ProcessDefinitionQuery orderByProcessDefinitionName() {
        return (ProcessDefinitionQuery)this.orderBy(ProcessDefinitionQueryProperty.PROCESS_DEFINITION_NAME);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getProcessDefinitionManager().findProcessDefinitionCountByQueryCriteria(this);
    }

    @Override
    public List<ProcessDefinition> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        return commandContext.getProcessDefinitionManager().findProcessDefinitionsByQueryCriteria(this, page);
    }

    @Override
    public void checkQueryOk() {
        super.checkQueryOk();
        if (this.latest && (this.id != null || this.name != null || this.nameLike != null || this.version != null || this.deploymentId != null)) {
            throw new ActivitiException("Calling latest() can only be used in combination with key(String) and keyLike(String)");
        }
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getNameLike() {
        return this.nameLike;
    }

    public String getKey() {
        return this.key;
    }

    public String getKeyLike() {
        return this.keyLike;
    }

    public Integer getVersion() {
        return this.version;
    }

    public boolean isLatest() {
        return this.latest;
    }

    public String getCategory() {
        return this.category;
    }

    public String getCategoryLike() {
        return this.categoryLike;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getResourceNameLike() {
        return this.resourceNameLike;
    }

    public SuspensionState getSuspensionState() {
        return this.suspensionState;
    }

    public void setSuspensionState(SuspensionState suspensionState) {
        this.suspensionState = suspensionState;
    }

    @Override
    public ProcessDefinitionQueryImpl startableByUser(String userId) {
        if (userId == null) {
            throw new ActivitiException("userId is null");
        }
        this.authorizationUserId = userId;
        return this;
    }
}

