/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.activiti.engine.impl.bpmn.behavior.FlowNodeActivityBehavior;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.process.ActivityImpl;

public class BoundaryEventActivityBehavior
extends FlowNodeActivityBehavior {
    private static Logger log = Logger.getLogger(BoundaryEventActivityBehavior.class.getName());
    protected boolean interrupting;
    protected String activityId;

    public BoundaryEventActivityBehavior() {
    }

    public BoundaryEventActivityBehavior(boolean interrupting, String activityId) {
        this.interrupting = interrupting;
        this.activityId = activityId;
    }

    public void execute(ActivityExecution execution) throws Exception {
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        ActivityImpl boundaryActivity = executionEntity.getProcessDefinition().findActivity(this.activityId);
        ActivityImpl interruptedActivity = executionEntity.getActivity();
        executionEntity.setActivity(boundaryActivity);
        List<PvmTransition> outgoingTransitions = boundaryActivity.getOutgoingTransitions();
        ArrayList<ActivityExecution> interruptedExecutions = null;
        if (this.interrupting) {
            if (executionEntity.getSubProcessInstance() != null) {
                executionEntity.getSubProcessInstance().deleteCascade(executionEntity.getDeleteReason());
            }
            interruptedExecutions = new ArrayList<ActivityExecution>(executionEntity.getExecutions());
            for (ExecutionEntity executionEntity2 : interruptedExecutions) {
                executionEntity2.deleteCascade("interrupting boundary event '" + execution.getActivity().getId() + "' fired");
            }
            execution.takeAll(outgoingTransitions, interruptedExecutions);
        } else {
            ExecutionEntity concurrentRoot = executionEntity.getParent().isConcurrent() ? executionEntity.getParent() : executionEntity;
            ExecutionEntity executionEntity3 = concurrentRoot.createExecution();
            executionEntity3.setActive(true);
            executionEntity3.setScope(false);
            executionEntity3.setConcurrent(true);
            executionEntity3.takeAll(outgoingTransitions, Collections.EMPTY_LIST);
            executionEntity3.remove();
            executionEntity.setActivity(interruptedActivity);
        }
    }

    public boolean isInterrupting() {
        return this.interrupting;
    }

    public void setInterrupting(boolean interrupting) {
        this.interrupting = interrupting;
    }
}

