/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.Condition;
import org.activiti.engine.impl.bpmn.behavior.GatewayActivityBehavior;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.process.TransitionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InclusiveGatewayActivityBehavior
extends GatewayActivityBehavior {
    private static Logger log = Logger.getLogger(InclusiveGatewayActivityBehavior.class.getName());

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(ActivityExecution execution) throws Exception {
        execution.inactivate();
        this.lockConcurrentRoot(execution);
        PvmActivity activity = execution.getActivity();
        if (!this.activeConcurrentExecutionsExist(execution)) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("inclusive gateway '" + activity.getId() + "' activates");
            }
            List<ActivityExecution> joinedExecutions = execution.findInactiveConcurrentExecutions(activity);
            String defaultSequenceFlow = (String)execution.getActivity().getProperty("default");
            ArrayList<PvmTransition> transitionsToTake = new ArrayList<PvmTransition>();
            for (PvmTransition outgoingTransition : execution.getActivity().getOutgoingTransitions()) {
                Condition condition;
                if (defaultSequenceFlow != null && outgoingTransition.getId().equals(defaultSequenceFlow) || (condition = (Condition)outgoingTransition.getProperty("condition")) != null && !condition.evaluate(execution)) continue;
                transitionsToTake.add(outgoingTransition);
            }
            if (transitionsToTake.size() > 0) {
                execution.takeAll(transitionsToTake, joinedExecutions);
                return;
            } else {
                if (defaultSequenceFlow == null) throw new ActivitiException("No outgoing sequence flow of the inclusive gateway '" + execution.getActivity().getId() + "' could be selected for continuing the process");
                PvmTransition defaultTransition = execution.getActivity().findOutgoingTransition(defaultSequenceFlow);
                if (defaultTransition == null) throw new ActivitiException("Default sequence flow '" + defaultSequenceFlow + "' could not be not found");
                execution.take(defaultTransition);
            }
            return;
        } else {
            if (!log.isLoggable(Level.FINE)) return;
            log.fine("Inclusive gateway '" + activity.getId() + "' does not activate");
        }
    }

    public boolean activeConcurrentExecutionsExist(ActivityExecution execution) {
        PvmActivity activity = execution.getActivity();
        if (execution.isConcurrent()) {
            for (ActivityExecution activityExecution : execution.getParent().getExecutions()) {
                if (!activityExecution.isActive() || activityExecution.getActivity() == activity) continue;
                boolean reachable = false;
                TransitionImpl pvmTransition = ((ExecutionEntity)activityExecution).getTransitionBeingTaken();
                reachable = pvmTransition != null ? this.isReachable(pvmTransition.getDestination(), activity, new HashSet<PvmActivity>()) : this.isReachable(activityExecution.getActivity(), activity, new HashSet<PvmActivity>());
                if (!reachable) continue;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("an active concurrent execution found: '" + activityExecution.getActivity());
                }
                return true;
            }
        } else if (execution.isActive()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("an active concurrent execution found: '" + execution.getActivity());
            }
            return true;
        }
        return false;
    }

    protected boolean isReachable(PvmActivity srcActivity, PvmActivity targetActivity, Set<PvmActivity> visitedActivities) {
        if (srcActivity.equals(targetActivity)) {
            return true;
        }
        visitedActivities.add(srcActivity);
        List<PvmTransition> transitionList = srcActivity.getOutgoingTransitions();
        if (transitionList != null && transitionList.size() > 0) {
            for (PvmTransition pvmTransition : transitionList) {
                boolean reachable;
                PvmActivity destinationActivity = pvmTransition.getDestination();
                if (destinationActivity == null || visitedActivities.contains(destinationActivity) || !(reachable = this.isReachable(destinationActivity, targetActivity, visitedActivities))) continue;
                return true;
            }
        }
        return false;
    }
}

